<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan extends CI_Controller {

	function __construct() {
		parent::__construct();
		//validasi jika user belum login
		if ($this->session->userdata('masuk') != TRUE) {
			$url = base_url();
			redirect($url);
		}

//		if ($this->session->userdata('akses') != 'manager') {
//			$url = base_url('dashboard/');
//			redirect($url);
	//	}
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('laporan_model');
		$this->load->helper('random');
		$this->db4=$this->load->database('db4', TRUE);
	}

public function masuk_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDatamasukTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDatamasukTransaksi($tanggal);
		}
		$this->load->view('laporan/masuk_transaksi', $data);
	}
	public function retur() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['totalretur'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['retur'] = $this->laporan_model->getDataReturFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['retur'] = $this->laporan_model->getDataRetur($tanggal);
		}
		$this->load->view('laporan/retur', $data);
	}

	public function biaya() {
		$data['bulan'] = date('m');
		$this->load->view('header', $data, FALSE);
		$this->load->view('laporan/biaya');
	}
	
	public function alurkas() {
		$data['bulan'] = date('m');
		$this->load->view('header', $data, FALSE);
		$this->load->view('laporan/alurkas');
	}

	public function view_biaya() {
		$tipe = $this->input->post('action');
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$tgl_awal = $tahun . "-" . $bulan . "-01";
		$tgl_akhir = $tahun . "-" . $bulan . "-31";
		$data['toko'] = $this->laporan_model->get_toko();
		$data['bln'] = $bulan;
		$data['thn'] = $tahun;
		if ($tipe == 'Rekap') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_a'] = 0;
			$data['tot_b'] = 0;
			$data['tot_c'] = 0;
			$data['tot_d'] = 0;
			$data['tot_tot'] = 0;
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRekap($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_pengeluaran_rekap', $data, FALSE);
		} elseif ($tipe == 'Rinci') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci($tgl_awal, $tgl_akhir);
			$data['biayap'] = $this->laporan_model->getDataPengeluaranRincip($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_pengeluaran_rinci', $data, FALSE);
		}
	}
	
	public function view_alurkas() {
		$tipe = $this->input->post('action');
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$tgl_awal = $tahun . "-" . $bulan . "-01";
		$tgl_akhir = $tahun . "-" . $bulan . "-31";
		$data['toko'] = $this->laporan_model->get_toko();
		$data['bln'] = $bulan;
		$data['thn'] = $tahun;
		if ($tipe == 'Rekap') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_a'] = 0;
			$data['tot_b'] = 0;
			$data['tot_c'] = 0;
			$data['tot_d'] = 0;
			$data['tot_e'] = 0;
			$data['tot_f'] = 0;
			$data['tot_g'] = 0;
			$data['tot_h'] = 0;
			$data['tot_i'] = 0;
			$data['tot_j'] = 0;
			$data['tot_k'] = 0;
			$data['tot_l'] = 0;
			$data['tot_m'] = 0;
			$data['tot_tot'] = 0;
			$data['tot_totp'] = 0;
			$data['tot_tot1'] = 0;
			$data['tot_tot2'] = 0;
			$data['tot_totl'] = 0;
			$data['biaya'] = $this->laporan_model->getDataalurkasRekap($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_alurkas_rekap', $data, FALSE);
		} elseif ($tipe == 'Rinci') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_a'] = 0;
			$data['tot_b'] = 0;
			$data['tot_c'] = 0;
			$data['tot_d'] = 0;
			$data['tot_e'] = 0;
			$data['tot_f'] = 0;
			$data['tot_g'] = 0;
			$data['tot_h'] = 0;
			$data['tot_i'] = 0;
			$data['tot_j'] = 0;
			$data['tot_k'] = 0;
			$data['tot_l'] = 0;
			$data['tot_m'] = 0;
			$data['tot_tot'] = 0;
			$data['tot_totp'] = 0;
			$data['tot_tot1'] = 0;
			$data['tot_tot2'] = 0;
			$data['tot_totl'] = 0;
			$data['biaya'] = $this->laporan_model->getDataalurkasRinci($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_alurkas_rinci', $data, FALSE);
		}
	}

	public function nilai_persediaan() {
		$nilai_persediaan = $this->laporan_model->getNilaiPersediaan();
		$data['toko'] = $this->laporan_model->get_toko();
		if ($nilai_persediaan) {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_beli'] = 0;
			$data['tot_jual'] = 0;
			$data['tot_nbeli'] = 0;
			$data['tot_njual'] = 0;
			$data['nilai_modal'] = 0;
			$data['nilai_jual'] = 0;
			$data['nilai_persediaan'] = $nilai_persediaan;
			$this->load->view('laporan/lap_nilai_persediaan', $data, FALSE);
		}
	}

	public function pembelian() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['tot_harga'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['pembelian'] = $this->laporan_model->getDataPembelianFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['pembelian'] = $this->laporan_model->getDataPembelian($tanggal);
		}
		$this->load->view('laporan/pembelian', $data);
	}

	public function penjualan_transaksi() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanTransaksi($tanggal);
		}
		$this->load->view('laporan/penjualan_transaksi', $data);
	}

	public function penjualan_barang() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$jenis=$a;
		$jual=$b;
		$ketjual='Semua';
		$ketjenis='Semua';
		if ($b=='s1') {$ketjual='Siang'; }
		if ($b=='s2') {$ketjual='Malam'; }
		
		if ($a=='al') {$ketjenis='Semua'; }
		if ($a=='tl') {$ketjenis='Total'; }
		if ($a=='do') {$ketjenis='DO'; }
		if ($a=='pr') {$ketjenis='Promo'; }
		if ($a=='gf') {$ketjenis='Gofood'; }
		if ($a=='gr') {$ketjenis='Grabfood'; }
		if ($a=='sp') {$ketjenis='Shopeefood'; }
		if ($a=='rg') {$ketjenis='Reguler'; }
		
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totppn'] = 0;
		$data['totbrt'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['jenis'] = $jenis;
		$data['ketjenis'] = $ketjenis;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarangFilter($tgl_awal, $tgl_akhir,$jual);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarang($tanggal);
		}
		$this->load->view('laporan/penjualan_barang', $data);
	}
		public function penjualandetail() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter1');
		$kdtoko = $this->input->get('kedai');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$g = $this->input->get('g');
		$h = $this->input->get('h');
		$i = $this->input->get('i');
		
		$jenis=$a;
		$jual=$b;
		$ketjual='Semua';
		$ketjenis='Semua';
		if ($b=='4') {$ketjual='Mie Djoetek'; }
		if ($b=='5') {$ketjual='Topping'; }
		if ($b=='2') {$ketjual='Snack'; }
		if ($b=='6') {$ketjual='Bavarage'; }
		
		if ($a=='al') {$ketjenis='Semua'; }
		if ($a=='tl') {$ketjenis='Total'; }
		if ($a=='do') {$ketjenis='DO'; }
		if ($a=='pr') {$ketjenis='Promo'; }
		if ($a=='gf') {$ketjenis='Gofood'; }
		if ($a=='gr') {$ketjenis='Grabfood'; }
		if ($a=='sp') {$ketjenis='Shopeefood'; }
		if ($a=='rg') {$ketjenis='Reguler'; }
		
		$tgl_akhir = $g . "-" . $h . "-" . $i;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totbpro'] = 0;
		$data['totproex'] = 0;
		$data['totprorpex'] = 0;
		$data['totpromem'] = 0;
		$data['totprorpmem'] = 0;
		$data['totprorp'] = 0;
		$data['totbprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['jenis'] = $jenis;
		$data['ketjenis'] = $ketjenis;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_tokoku($kdtoko);
		if ($filter == "ok1") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarangFilter2($tgl_awal, $tgl_akhir,$jual,$kdtoko);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarang2($tanggal,$kdtoko);
		}
		$this->load->view('laporan/penjualandetail', $data);
	}
	public function penjualan_promo() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$kdcabang = $this->input->get('kedai');
		if($kdcabang== null) {$kdcabang='KDR01';}
		$jpromo='2';
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$kdpromo = $this->input->get('kdpromo');
		$cpr=$this->db->query("select * from promoheader where idprogram='$kdpromo';");
		$kdpr=$cpr->row_array();
		if(isset($kdpr)) {
		    $jpromo=$kdpr['jnsdisc'];
		    }
		
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['nppn'] = 0;
		$data['total'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['kdpromo'] = $this->laporan_model->getkdpromo();
		$data['toko'] = $this->laporan_model->get_tokoku($kdcabang);
		$data['jpromo'] = $jpromo;
		
		    if($jpromo=='2') {      
			    $data['penjualan'] = $this->laporan_model->getDataPenjualanpromoFilter($tgl_awal, $tgl_akhir,$kdpromo,$kdcabang);
		    } else  {
		        $data['penjualan'] = $this->laporan_model->getDataPenjualanpromoFilter1($tgl_awal, $tgl_akhir,$kdpromo,$kdcabang);
		    }
		    
		
		$this->load->view('laporan/penjualan_promo', $data);
	}

	public function penjualan_barang1() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter1');
		$kdtoko = $this->input->get('kedai');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$jenis=$a;
		$jual=$b;
		$ketjual='Semua';
		$ketjenis='Semua';
		if ($b=='s1') {$ketjual='Siang'; }
		if ($b=='s2') {$ketjual='Malam'; }
		
		if ($a=='al') {$ketjenis='Semua'; }
		if ($a=='tl') {$ketjenis='Total'; }
		if ($a=='do') {$ketjenis='DO'; }
		if ($a=='pr') {$ketjenis='Promo'; }
		if ($a=='gf') {$ketjenis='Gofood'; }
		if ($a=='gr') {$ketjenis='Grabfood'; }
		if ($a=='sp') {$ketjenis='Shopeefood'; }
		if ($a=='rg') {$ketjenis='Reguler'; }
		
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		
		$data['totbpro'] = 0;
		$data['totbprorp'] = 0;
		
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totky'] = 0;
		$data['totkyrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['jenis'] = $jenis;
		$data['ketjenis'] = $ketjenis;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_tokoku($kdtoko);
		if ($filter == "ok1") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarangFilter1($tgl_awal, $tgl_akhir,$jual,$kdtoko);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarang1($tanggal,$kdtoko);
		}
		$this->load->view('laporan/penjualan_barang1', $data);
	}

	public function profit() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['noo'] = 1;
		$data['tot_item'] = 0;
		$data['tot_modal'] = 0;
		$data['tot_pendapatan'] = 0;
		$data['tot_profit'] = 0;
		$data['totbiaya'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['profit'] = $this->laporan_model->getDataProfit($tgl_awal, $tgl_akhir);
			$data['subdiskon'] = $this->laporan_model->getDiskonBarang($tgl_awal, $tgl_akhir)->row();
			$data['subdisakhir'] = $this->laporan_model->getDiskonAkhir($tgl_awal, $tgl_akhir)->row();
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci($tgl_awal, $tgl_akhir);
		} else {
			$data['profit'] = $this->laporan_model->getDataProfit1($tanggal);
			$data['subdiskon'] = $this->laporan_model->getDiskonBarang1($tanggal)->row();
			$data['subdisakhir'] = $this->laporan_model->getDiskonAkhir1($tanggal)->row();
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci1($tanggal);
		}
		$this->load->view('laporan/profit', $data);
	}

	public function rekap() {
		$this->load->model('grafik_model');
		$data['year'] = date('Y');
		$data['bulan'] = date('m');
		$data['tahun'] = $this->grafik_model->getTahunJual()->result_array();
		$this->load->view('header', $data, FALSE);
		$this->load->view('laporan/pilih_bulan');
	}

	public function rekapitulasi_penjualan() {
		$tahun = $this->input->post('tahun');
		$bulan = $this->input->post('bulan');
		$data_rekap = $this->laporan_model->getDataRekap($tahun, $bulan)->result();
		$data['diskon'] = $this->laporan_model->getDiskon($tahun, $bulan)->result();
		$data['toko'] = $this->laporan_model->get_toko();
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$data['rekap'] = $data_rekap;
		$data['aa'] = 0;
		$data['bb'] = 0;
		$data['cc'] = 0;
		$data['dd'] = 0;
		$data['ee'] = 0;
		$data['ff'] = 0;
		$data['gg'] = 0;
		$data['tot'] = 0;
		$data['tot_a'] = 0;
		$data['tot_b'] = 0;
		$data['tot_c'] = 0;
		$data['tot_d'] = 0;
		$data['tot_tot'] = 0;
		$data['biaya'] = $this->laporan_model->getDataPengeluaranRekapitulasi($tahun, $bulan);
		$this->load->view('laporan/lap_rekap', $data, FALSE);
	}

}

/* End of file Laporan.php */
/* Location: ./application/controllers/Laporan.php */