<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kasir extends CI_Controller {

	function __construct() {
		parent::__construct();
		//validasi jika user belum login
		if ($this->session->userdata('masuk') != TRUE) {
			$url = base_url();
			redirect($url);
		}

		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('kasir_model');
		$this->load->helper('random');
		$this->db2=$this->load->database('db2', TRUE);
	}
	public function input_biaya() {
		$data['level'] = $this->session->userdata('akses');
		$this->load->view('header', $data);
		$this->load->view('kasir/biaya');
	}
public function laporan_pdf(){

    $data = array(
        "dataku" => array(
            "nama" => "Petani Kode",
            "url" => "http://petanikode.com"
        )
    );

    $this->load->library('pdf');

    $this->pdf->setPaper('A4', 'potrait');
    $this->pdf->filename = "laporan-petanikode.pdf";
    $this->pdf->load_view('laporan_pdf', $data);


}
	public function simpan_biaya() {
		$jenis = $this->input->post('jenis_biaya');
		$biaya = str_replace(".", "", $this->input->post('biaya'));
		$ket = $this->input->post('ket');
		$tgl = date('Y-m-d');
		$id_user = $this->session->userdata('ses_username');
		$kdtoko = $this->session->userdata('kd_toko');

		$data = array(
			'tgl' => $tgl,
			'id_user' => $id_user,
			'biaya' => $biaya,
			'jenis' => $jenis,
			'ket' => $ket,
			'kdcabang' => $kdtoko,
		);
		$this->db->insert('tabel_biaya', $data);
		echo $this->session->set_flashdata('msg', 'Input biaya berhasil');
		redirect('kasir/input-biaya/', 'refresh');
	}

	public function mutasi() {
		$data['level'] = $this->session->userdata('akses');
		$this->load->view('header', $data);
		$this->load->view('kasir/mutasi');
	}

	public function get_detail_produk() {
		$idbarang = $this->input->post('idbarang');
		$data = $this->kasir_model->get_detail_produk($idbarang);
		echo json_encode($data);
	}
	public function simpan_mutasi() {
		$jenis = $this->input->post('jenis_mutasi');
		$kode = $this->input->post('kd_barang');
		$jumlah = $this->input->post('jumlah');
		$kdtoko = $this->session->userdata('kd_toko');
		$ket = $this->input->post('ket');
		$tgl = date('Y-m-d');
		$waktu = date('Y-m-d');
		$jam = date('H:i:s');
		$kd_toko = "SS001";
		$publish = "0";
		$user = $this->session->userdata('ses_username');

		if ($jenis == "Masuk") {
			$cek_stok = $this->kasir_model->cek_stok_mutasi($kode);
			$i = $cek_stok->row_array();
			$stok_sekarang = $i['stok'];
			$stok_baru = (int) $jumlah + (int) $stok_sekarang;
			$this->db->query("UPDATE tabel_stok_toko SET stok='$stok_baru' WHERE kd_barang='$kode' and kd_toko='$kdtoko'");
			$this->db->query("INSERT INTO tabel_mutasi (mutasi,kd_barang,jumlah,ket,tgl) VALUES ('$jenis','$kode','$jumlah','$ket','$tgl')");
			$this->db->query("INSERT INTO tabel_kartu_stok (kode_toko,kode_barang,waktu,jam,sebelumnya,keluar,masuk,saldo,keterangan,user,publish) VALUES ('$kd_toko','$kode','$waktu','$jam','$stok_sekarang','0','$jumlah','$stok_baru','$ket','$user','$publish')");
			echo $this->session->set_flashdata('msg', 'Input mutasi masuk ' . $kode . ' berhasil');
			redirect('kasir/mutasi/', 'refresh');
		} else {
			$cek_stok = $this->kasir_model->cek_stok_mutasi($kode); //disini
			$i = $cek_stok->row_array();
			$stok_sekarang = $i['stok'];
			//if ($stok_sekarang > $jumlah) {
		//		echo $this->session->set_flashdata('error', 'Input mutasi gagal, stok tidak mencukupi');
		//		redirect('kasir/mutasi/', 'refresh');
		//	} else {
				$stok_baru = (int) $stok_sekarang - (int) $jumlah;
				$this->db->query("UPDATE tabel_stok_toko SET stok='$stok_baru' WHERE kd_barang='$kode' and kd_toko='$kdtoko'");
				$this->db->query("INSERT INTO tabel_mutasi (mutasi,kd_barang,jumlah,ket,tgl) VALUES ('$jenis','$kode','$jumlah','$ket','$tgl')");
				$this->db->query("INSERT INTO tabel_kartu_stok (kode_toko,kode_barang,waktu,jam,sebelumnya,keluar,masuk,saldo,keterangan,user,publish) VALUES ('$kd_toko','$kode','$waktu','$jam','$stok_sekarang','$jumlah','0','$stok_baru','$ket','$user','$publish')");
				echo $this->session->set_flashdata('msg', 'Input mutasi keluar ' . $kode . ' berhasil');
				redirect('kasir/mutasi/', 'refresh');
		//	}
		}
	}

	public function retur() {
		$this->load->view('header');
		$this->load->view('kasir/retur');
	}
	
	public function get_data_faktur() {
		$nofak = $this->input->post('nofak');
		$data['list'] = $this->kasir_model->get_list($nofak);
		$data['faktur'] = $this->kasir_model->detail_faktur($nofak);
		
		$hasil = $this->load->view('kasir/list_retur', $data, true);
		$callback = array(
			'hasil' => $hasil,
		);
		echo json_encode($callback);
	}

	public function retur_item() {
		$nofak = $this->uri->segment(3);
		$kd_barang = base64_decode($this->uri->segment(4));
		$data_barang = $this->kasir_model->getProdukRetur($nofak, $kd_barang)->row();
		if ($data_barang) {
			$data['produk'] = $data_barang;
			$this->load->view('header', $data);
			$this->load->view('kasir/retur_item');
		} else {
			$this->load->view('error404');
		}
	}

	public function simpan_retur() {
		$nofak = $this->input->post('nofak');
		$kd_barang = $this->input->post('kd_barang');
		$jum_retur = $this->input->post('jum_retur');
		$ket = $this->input->post('ket');
		$tgl = date('Y-m-d');
		$data_barang = $this->kasir_model->getProdukRetur($nofak, $kd_barang);
		$data_stok = $this->kasir_model->getStokRetur($kd_barang);
		$i = $data_barang->row_array();
		$s = $data_stok->row_array();
		$nm_barang = $i['nm_barang'];
		$harga_item = $i['harga'];
		$stok_awal = $s['stok'];
		$stok_sekarang = (int) $stok_awal + (int) $jum_retur;
		$total_harga_retur = (int) $jum_retur * (int) $harga_item;
		$kdtoko = $this->session->userdata('kd_toko');
		$waktu = date('Y-m-d');
		$jam = date('H:i:s');
		$user = $this->session->userdata('ses_username');
		$publish = "0";
		$this->db->query("INSERT INTO tabel_retur (no_faktur_penjualan,kd_barang,nm_barang,jumlah,total_retur,ket,tgl) VALUES ('$nofak','$kd_barang','$nm_barang','$jum_retur','$total_harga_retur','$ket','$tgl')");
		$this->db->query("INSERT INTO tabel_kartu_stok (kode_toko,kode_barang,waktu,jam,sebelumnya,keluar,masuk,saldo,keterangan,user,publish) VALUES ('$kd_toko','$kd_barang','$waktu','$jam','$stok_awal','0','$jum_retur','$stok_sekarang','$ket','$user','$publish')");
		$this->db->query("UPDATE tabel_rinci_penjualan SET retur='$jum_retur' WHERE kd_barang='$kd_barang' AND no_faktur_penjualan='$nofak'");
		$this->db->query("UPDATE tabel_stok_toko SET stok='$stok_sekarang' WHERE kd_barang='$kd_barang' and kd_toko='$kdtoko'");
		echo $this->session->set_flashdata('msg', 'Retur Sukses');
		redirect('kasir/retur/', 'refresh');
	}

	public function rekap() {
        $tgl = $this->input->post('utgl');
		$akses = $this->session->userdata('akses');
		$kdtoko = $this->session->userdata('kd_toko');
		$data['tanggal'] = $tgl;
		$data['no'] = 1;
		$data['noo'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['nppn'] = 0;
		$data['grandtot'] = 0;
		$data['rg'] = 0;
		$data['rgdo'] = 0;
		$data['rgta'] = 0;
		$data['gofood'] = 0;
		$data['grab'] = 0;
		$data['shopee'] = 0;
		$data['ongkir'] = 0;
		$data['tot_biaya'] = 0;
		$data['penjualan'] = $this->kasir_model->dataTransaksiHariIni($tgl,$kdtoko);
		$data['pengeluaran'] = $this->kasir_model->dataPengeluaranHariIniAll($tgl,$kdtoko);
		$this->load->view('header', $data);
		$this->load->view('kasir/rekap_harian');
	}

	public function rekapd() {
		$jam = $this->input->post('ujam');
		$tgl=date('Y-m-d'); 
		if ($jam==Null) {$jam=date('H:i'); }
		$akses = $this->session->userdata('akses');
		$kdtoko = $this->session->userdata('kd_toko');
		$data['tanggal'] = $tgl;
		$data['no'] = 1;
		$data['noo'] = 1;
		$data['grandtot'] = 0;
		$data['rg'] = 0;
		$data['rgdo'] = 0;
		$data['rgta'] = 0;
		$data['gofood'] = 0;
		$data['grab'] = 0;
		$data['penjualan'] = $this->kasir_model->dataTransaksiHariInid1($jam,$tgl,$kdtoko);
		$this->load->view('header', $data);
		$this->load->view('kasir/rekap_hariand');
	}

	public function reprint_struk() {
		$tgl = date('d-m-Y');
		$waktu = date('H:i:s');
		$nofaktur = $this->uri->segment(3);
		$data_faktur = $this->kasir_model->reprintStruk($nofaktur)->row();
		$produk = $this->kasir_model->getProdukDijual($nofaktur);
		if ($data_faktur) {
			$data['toko'] = $this->kasir_model->get_toko();
			$data['faktur'] = $data_faktur;
			$data['tgl'] = $tgl;
			$data['waktu'] = $waktu;
			$data['produk'] = $produk;
			$data['total_item'] = 0;
			$data['subtotal'] = 0;
			$this->load->view('kasir/reprint_struk_transaksi', $data);
		} else {
			$this->load->view('error404');
		}
	}

	public function cetak_rekap() {
	$akses = $this->session->userdata('akses');
		$waktu = date('H:i:s');
		$tgl_sort = date('Y-m-d');
	
		$id_user = $this->session->userdata('ses_username');
		$kdtoko = $this->session->userdata('kd_toko');
		$kodea = $this->db->query("select * from tanggal where kdcabang='$kdtoko';");
		$kodeaw=$kodea->row_array();
		$tgl=$kodeaw['tgl'];
		$data_rekap = $this->kasir_model->getRekapHarian($kdtoko,$tgl);
		$data['toko'] = $this->kasir_model->get_toko();
		$data['tgl'] = $tgl;
		$data['waktu'] = $waktu;
		$data['user'] = $id_user;
		$data['total_debet'] = 0;
		$data['total_cash'] = 0;
		$data['total_ppn'] = 0;
		$data['total_ongkir'] = 0;
		$data['total_tetap'] = 0;
		$data['total_promo'] = 0;
		$data['total_biaya'] = 0;
		$data['rekap'] = $data_rekap;
		$data['pengeluaran'] = $this->kasir_model->datarekapPengeluaranHarian($kdtoko,$tgl);
		$data['tetap'] = $this->kasir_model->datarekapPengeluarantetap($kdtoko,$tgl);
		$data['biaya'] = $this->kasir_model->getRekapbiaya($kdtoko,$tgl);
		$data['trekap'] = $this->kasir_model->datarekap($kdtoko,$tgl);
		$this->load->view('kasir/cetak_rekap_harian', $data);
	}
	
public function cetak_rekapd() {
	$akses = $this->session->userdata('akses');
		$waktu = date('H:i:s');
		$tgl_sort = date('Y-m-d');
		$id_user = $this->session->userdata('ses_username');
		$kdtoko = $this->session->userdata('kd_toko');
		$kodea = $this->db->query("select * from tanggal where kdcabang='$kdtoko';");
		$kodeaw=$kodea->row_array();
		$idbarang='2a10';
		$tgl=date('Y-m-d');
		$data['toko'] = $this->kasir_model->get_toko();
		$data['tgl'] = $tgl;
		$data['waktu'] = $waktu;
		$data['user'] = $id_user;
		$data['total_debet'] = 0;
	    $data['stokd'] = $this->kasir_model->getstokskr($kdtoko,$idbarang,$tgl);
		$data['trekapd'] = $this->kasir_model->datarekapd($kdtoko,$tgl);
		//$data['promosi'] = $this->kasir_model->datapromo($kdtoko,$tgl);
		$this->load->view('kasir/cetak_rekap_hariand', $data);
	}
	
	public function barang_masuk() {
	    $tgl = date('Y-m-d');
	    $nobukti = $this->input->post('sj');
		$kdtoko = $this->session->userdata('kd_toko');	
		$kodea = $this->db->query("select * from tabel_toko where kd_toko='$kdtoko';");
		$kodeaw=$kodea->row_array();
		$kdgudang=$kodeaw['kdgudang'];
		$isi=$this->kasir_model->isidataBarangMasuk($nobukti,$kdgudang);
		
		$tgl = date('Y-m-d');
		$data['no'] = 1;
		$data['tanggal'] = $tgl;
		$data['daftar'] = $this->kasir_model->dataBarangMasuk($tgl);
		$this->load->view('header', $data);
		$this->load->view('kasir/barang_masuk');
	}
	public function edit_jumlah_masuk() {
	    $nobukti = $this->input->post('nofak');
	    $kdbrg = $this->input->post('kdbrg');
	    $jml = $this->input->post('jml');
		$kdtoko = $this->session->userdata('kd_toko');		
		$this->db->query("UPDATE stokdetail SET qtyterima='$jml' WHERE  nobukti='$nobukti' and kdbrg='$kdbrg';");
		$tgl = date('Y-m-d');
		$data['no'] = 1;
		$data['tanggal'] = $tgl;
		$data['daftar'] = $this->kasir_model->dataBarangMasuk($tgl);
		$this->load->view('header', $data);
		$this->load->view('kasir/barang_masuk');
	}
	public function edit_ket_masuk() {
	    $nobukti = $this->input->post('nofak');
	    $kdbrg = $this->input->post('kdbrg');
	    $keter = $this->input->post('keter');
		$kdtoko = $this->session->userdata('kd_toko');		
		$this->db->query("UPDATE stokdetail SET keter='$keter' WHERE  nobukti='$nobukti' and kdbrg='$kdbrg';");
		$tgl = date('Y-m-d');
		$data['no'] = 1;
		$data['tanggal'] = $tgl;
		$data['daftar'] = $this->kasir_model->dataBarangMasuk($tgl);
		$this->load->view('header', $data);
		$this->load->view('kasir/barang_masuk');
	}

	public function masuk_token() {
	    $waktu = date('H:i:s');
		$tgl = date('Y-m-d');
		$jam=date("d-m-Y H:i:s");
	    $nobukti = $this->input->post('nobuk');
	    $token = $this->input->post('token');
	    $note = $this->input->post('note');
		$kdtoko = $this->session->userdata('kd_toko');		
		$user = $this->session->userdata('ses_username');
		$stok_sekarang=0;
		$publish=0;
		$stok_porsi = $this->kasir_model->getStokdetail($nobukti,$tgl)->result();
		foreach ($stok_porsi as $key) {
			$kode = $key->kdbrg;
			$jumlah = $key->qtyterima;
			$keter = $key->keter;
			$stok_baru = $jumlah;
			$ctok = $this->kasir_model->cek_stok_mutasi($kode);
			if ($ctok->num_rows() > 0) {
			    $i = $ctok->row_array();
			    $stok_sekarang = $i['stok']; 
			    $stok_baru = $jumlah + $stok_sekarang;
			    $this->db->query("UPDATE tabel_stok_toko SET stok='$stok_baru' WHERE kd_barang='$kode' and kd_toko='$kdtoko'");
			} else {	    
			    $this->db->query("insert ignore into tabel_stok_toko(kd_toko,kd_barang,stok,tgl_perubahan) value ('$kdtoko','$kode','$jumlah','$jam') " );
			    
			}
			$this->db->query("INSERT INTO tabel_kartu_stok (kode_toko,kode_barang,waktu,jam,sebelumnya,keluar,masuk,saldo,keterangan,user,publish,nobukti,jtran) VALUES
			                                               ('$kdtoko','$kode','$tgl','$waktu','$stok_sekarang','0','$jumlah','$stok_baru','$keter','$user','$publish','$nobukti','TP')");    
			$this->db->query("UPDATE stokdetail SET st='2' where  nobukti='$nobukti' and kdbrg='$kode' and st<>'2';");                                            
		}
		
		$this->db->query("UPDATE stokheader SET st='6',token='$token',note='$note',tglaprove='$tgl',jamaprove='$waktu' WHERE  nobukti='$nobukti' and st='2';");
		$data['no'] = 1;
		$data['tanggal'] = $tgl;
		$data['daftar'] = $this->kasir_model->dataBarangMasuk($tgl);
		$this->load->view('header', $data);
		$this->load->view('kasir/barang_masuk');
	}
	
	public function cetak_barang_masuk() {
		$tgl = date('Y-m-d');
		$data['toko'] = $this->kasir_model->get_toko();
		$data['no'] = 1;
		$data['tanggal'] = $tgl;
		$data['masuk'] = $this->kasir_model->dataBarangMasuk($tgl);
		$this->load->view('kasir/cetak_barang_masuk', $data);
	}


	public function nomor_faktur() {
		$ymd = date('ymd');
		$tgl_now = date('Y-m-d');
		$waktu = date('H:i:s');		
		$id_user = $this->session->userdata('ses_username');		
		$kodea = $this->db->query("select kd_toko from tabel_user where id_user='$id_user';");
		$kodeaw=$kodea->row_array();
		$kodeawal=$this->session->userdata('kd_toko');		
		$kodefak=$kodeawal.$ymd;
		
		$max = $this->db->query("SELECT MAX(RIGHT(no_faktur_penjualan,3)) AS last FROM tabel_penjualan WHERE substr(no_faktur_penjualan,6,6)='$ymd'");
		$x = $max->row_array();
		$last = $x['last'];
		$cek = $this->db->query("SELECT * FROM tabel_penjualan WHERE selesai='0' AND substr(no_faktur_penjualan,6,6)='$ymd' and kdcabang='$kodeawal' order by no_faktur_penjualan limit 1;");
		$i = $cek->row_array();
		$user='';
		$selesai='';
		if(isset($i)) {
		    $user = $i['id_user'];
		    $selesai = $i['selesai'];
			$kdfak = $i['no_faktur_penjualan'];
		}
		if ($user == $id_user && $selesai == '0') {
			$nofaktur = $kdfak;
		} else {
			$nofaktur = $this->kasir_model->getNoFaktur($kodefak);
			$data = array(
				'no_faktur_penjualan' => $nofaktur,
				'tgl_penjualan' => $tgl_now,
				'waktu' => $waktu,
				'id_user' => $id_user,
				'kdcabang' => $kodeawal,
				'selesai' => '0',
			);
			$this->db->insert('tabel_penjualan', $data);
		}
		redirect('kasir/mesin-kasir/' . $nofaktur, 'refresh');
	}
	
	public function nomor_faktur1() {
		$noresi = $this->uri->segment(3);
		$ymd = date('ymd');
		$tgl_now = date('Y-m-d');
		$waktu = date('H:i:s');		
		$keter='Reg Mandiri';
		$jnsbayar='1';
		$id_user = $this->session->userdata('ses_username');		
		$kodeawal=$this->session->userdata('kd_toko');		
		$inv = $this->db->query("select * from tbl_invoice a
		                        left join tbl_pelanggan b on a.inv_plg_id=b.plg_id
		                        where a.inv_no='$noresi' and a.kdcabang='$kodeawal';");
		$inva=$inv->row_array();
		if (isset($inva)) {
		    $custno=$inva['inv_plg_id'];
		    $npelanggan=$inva['inv_plg_nama'];
		    $kdharga=$inva['layanan'];
		    $promo=$inva['promo'];
		    $kdcabang=$inva['kdcabang'];
		    $notelp=$inva['plg_notelp'];
		    $jnsbayar=$inva['jnsbayar'];
		    }
		
		$kodefak=$kodeawal.$ymd;
		$max = $this->db->query("SELECT MAX(RIGHT(no_faktur_penjualan,3)) AS last FROM tabel_penjualan WHERE substr(no_faktur_penjualan,6,6)='$ymd'");
		$x = $max->row_array();
		$last = $x['last'];
		$cek = $this->db->query("SELECT * FROM tabel_penjualan WHERE selesai='0' AND substr(no_faktur_penjualan,6,6)='$ymd' and kdcabang='$kodeawal' order by no_faktur_penjualan limit 1;");
		$i = $cek->row_array();
		$user='';
		$selesai='';
		if(isset($i)) {
		    $user = $i['id_user'];
		    $selesai = $i['selesai'];
			$kdfak = $i['no_faktur_penjualan'];
		}
		if ($user == $id_user && $selesai == '0') {
			$nofaktur = $kdfak;
			$data = array(
				'custno' =>$custno,
				'noorder' =>$noresi,
				'notelp' =>$notelp,
				'npelanggan' =>$npelanggan,
				'kdharga' =>'KH05',
				'layanan' =>$kdharga,
				'keter' =>$keter,
				'jnsbayar' =>$jnsbayar,
			);
			$this->db->where('no_faktur_penjualan',$nofaktur);
			$this->db->update('tabel_penjualan', $data);
		    redirect('kasir/mesin-kasir/' . $nofaktur, 'refresh');
		} else {
		    	//'layanan' => $kdharga,
				//'custno' =>$custno,
				//'notelp' =>$notelp,
				//'waiter1' =>$waiter1,
				//'waiter2' =>$waiter2,
				//'kurir' =>$kurir,
				//'struk' =>$struk,
				//'typecust' =>$type,
			//	'npelanggan' =>$npelanggan,
			//	'promo' =>$promo,
		//		'nomeja' =>$nomeja,
		//		'ongkir' =>$netongkir,
		//		'noorder' =>$noorder,
				
		    
			$nofaktur = $this->kasir_model->getNoFaktur($kodefak);
			$data = array(
				'no_faktur_penjualan' => $nofaktur,
				'tgl_penjualan' => $tgl_now,
				'waktu' => $waktu,
				'id_user' => $id_user,
				'kdcabang' => $kodeawal,
				'custno' =>$custno,
				'noorder' =>$noresi,
				'notelp' =>$notelp,
				'npelanggan' =>$npelanggan,
				'kdharga' =>'KH05',
				'layanan' =>$kdharga,
				'keter' =>$keter,
				'selesai' => '0',
				'jnsbayar' => $jnsbayar,
				
			);
			$this->db->insert('tabel_penjualan', $data);
		}
		redirect('kasir/mesin-kasir/' . $nofaktur, 'refresh');
	}


	public function nomor_faktur_new() {
		$ymd = date('ymd');
		$tgl_now = date('Y-m-d');
		$waktu = date('H:i:s');
		$id_user = $this->session->userdata('ses_username');
		$kodeawal = $this->session->userdata('kd_toko');
		$nofaktur = $this->kasir_model->getNoFaktur($ymd);
		$data = array(
			'no_faktur_penjualan' => $nofaktur,
			'tgl_penjualan' => $tgl_now,
			'waktu' => $waktu,
			'id_user' => $id_user,
			'kdcabang' => $kodeawal,
			'selesai' => '0',
		);
		$this->db->insert('tabel_penjualan', $data);
		redirect('kasir/mesin-kasir/' . $nofaktur, 'refresh');
	}


	public function mesin_kasir() {
		$tgl = date('Y-m-d');
		$data['menu'] = $this->kasir_model->getDataMenu();
		$data['pegawai'] = $this->kasir_model->getpegawai();
		$data['customer'] = $this->kasir_model->getcustomer();
		$data['promosi'] = $this->kasir_model->getpromo($tgl);
		$noresi = $this->uri->segment(3);
		$this->db->query("update tabel_penjualan set selesai='0' where no_faktur_penjualan='$noresi';");
		$username = $this->session->userdata('ses_username');
		$data_faktur = $this->kasir_model->getDataPenjualan($noresi, $username)->row();
		$list_barang = $this->kasir_model->getListPenjualan($noresi);				
		
		if ($data_faktur) {
			$data['tgl'] = date('Y-m-d');
			$data['faktur'] = $data_faktur;
			$data['list'] = $list_barang;
			$data['tot_item'] = 0;
			$data['tot_belanja'] = 0;
			$data['tot_nppn'] = 0;
			$data['tot_diskon'] = 0;
			$data['belanja'] = $this->kasir_model->getTotalBelanja($noresi)->row();
			$this->load->view('header', $data);
			$this->load->view('kasir/mesin_kasir');
		} else {
			$this->load->view('error404');
		}
	}

	public function penjualan_pending() {
		$noresi = $this->input->post('nofak_bayar');
		$this->db->query("update tabel_penjualan set selesai='3' where no_faktur_penjualan='$noresi';");
		$id_user = $this->session->userdata('ses_username');
		$now = date('Y-m-d');
		$before = date('Y-m-d', strtotime('-30 days', strtotime($now)));
		$data['pending'] = $this->kasir_model->transaksiPending($id_user, $now, $before);
		
		$data['no'] = 1;
		$this->load->view('header', $data);
		$this->load->view('kasir/penjualan_pending');
	}
	public function penjualan_edit() {
		$noresi = $this->input->post('nofaktur');
		$this->db->query("update tabel_penjualan set posting='0' where no_faktur_penjualan='$noresi';");
		$uri = base_url('kasir/mesin-kasir/') . $noresi;
		header("Location: " . $uri, TRUE);
		
	}

	public function go_to_bayar() {
		$noresi = $this->input->post('nofak_bayar');
		$total_penjualan = $this->input->post('total_belanja');
		$diskon = $this->input->post('diskon_belanja');
		$ket_diskon = $this->input->post('diskon_ket');
		$layan = $this->input->post('layan');
		$ongkir = $this->input->post('ongkir');
		$disc = $this->input->post('disc');
		$ndisc = $this->input->post('ndisc');
		$idpromo = $this->input->post('idpromo');
		$nppn = $this->input->post('nppn');
		$kdharga = $this->input->post('kdharga');
		$netongkir=0;
		$total_sdiskon = $total_penjualan - $diskon;
		if ($layan>1) {
		       if ($kdharga=='KH01') { 
			      
				if ($layan=='3') {
				    $diskon=0;
				    $nilai=0;
				     $ongkir=$this->db->query("select a.nilai from ongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$noresi';");
				     $onk=$ongkir->row_array();    
				     
				     $dongkir=$this->db->query("select a.diskon from detailongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$noresi';"); 
				     $donk=$dongkir->row_array(); 
				     if(isset($donk)) {$diskon=$donk['diskon'];}
				     if(isset($onk)) {$nilai=$onk['nilai'];}
				     $netongkir=$nilai-$diskon;
				                             
				    $this->db->query("update tabel_penjualan set ongkir='$netongkir' where no_faktur_penjualan ='$noresi' ;");
				}	        
		       }
		      
		}
		$dis=0;
		if ($idpromo != null) {
				$min=0;
				$max=0;
				$dd=0;
				
				$pr=$this->db->query("select minorder,maxdisc,disc1,ndisc1,jnspromo,jnsmenu,hari,jnslayanan,jnslayanan1,jnslayanan2 from promoheader where idprogram='$idpromo';");
				$dprom=$pr->row_array();
				if(isset($dprom)) {
					$min=$dprom['minorder'];
					$max=$dprom['maxdisc'];
					$dd=$dprom['disc1'];
					$ndd=$dprom['ndisc1'];
					$jnspromo=$dprom['jnspromo'];
					$jnslayanan=$dprom['jnslayanan'];
					$jnslayanan1=$dprom['jnslayanan1'];
					$jnslayanan2=$dprom['jnslayanan2'];
					
					if ($total_sdiskon>=$min) {
						if ($ndd>0) {$dis=$ndd;}	
						IF ($disc>0) {$dis=(($disc/100)*$total_sdiskon);}
						if ($dis>$max) {$dis=$max;}	
						}
					
					}
				if ($jnspromo=='2')	{
						$prd=$this->db->query("select a.kdbonus,a.minqty,a.maxqty,a.perqty,a.idmenu,a.qtybonus,b.nama_menu,b.harga_modal from promodetail a 
												left join tabel_menu b on a.kdbonus=b.kode_menu 						
												where a.idpromo='$idpromo';") ;
						$dpromd=$prd->row_array();
						$kdbonus=$dpromd['kdbonus'];	
						$qtybonus=$dpromd['qtybonus'];	
						$minqty=$dpromd['minqty'];	
						$maxqty=$dpromd['maxqty'];	
						$perqty=$dpromd['perqty'];
						$idmenu=$dpromd['idmenu'];
						$nmmenu=$dpromd['nama_menu'];
						$hgmodal=$dpromd['harga_modal'];
						
						$qtypromo=$this->db->query("select sum(qty) as total,nourut from fakturpromo where idmenu='$idmenu' and nobukti='$noresi' group by idmenu;");
						$qtyp=$qtypromo->row_array();
						if(isset($qtyp)) {
						$qtyjual=$qtyp['total'];
						$nourut=$qtyp['nourut'];
						if($min==0) {$min=1;}
						$qtypembagi=($total_sdiskon*1.1)/$min ;
						if($qtypembagi>=1) {
						    $qtyb=floor($qtypembagi);
						    if($qtyb>=$maxqty){
							$qtyb=$maxqty; 
							}
						} else {
						    $qtyb=(($qtyjual*$qtybonus)/$perqty);
						        if($qtyb>=$maxqty){
							        $qtyb=$maxqty; 
							}
						}
						if($layan<>'3') {
						        if (($total_sdiskon*1.1)>=$min) {
						               if($kdharga=='KH01') {
						                    $this->db->query("
							                INSERT IGNORE INTO tabel_rinci_penjualan(no_faktur_penjualan,nourut,kd_barang,nm_barang,jumlah,harga_modal,harga,kdpromo,sub_total_jual)
					                        value ('$noresi','$nourut','$kdbonus','$nmmenu','$qtyb','$hgmodal',0,'$idpromo',0);");
						                }
						        }
						    }
					}
				}
					
				}
		
		
		$netto=($total_sdiskon-$dis)+$netongkir+$nppn;
		$kdharga = $this->input->post('kdharga');
		$layan = $this->input->post('layan');
		
		if ($kdharga == 'KH01' or $kdharga == 'KH05') {
		    if ($layan == '3') {
		        $tglbayar = date('Y-m-d H:m:s');
		        $nbayar = $netto;
		        $jnsbayar='1';
		    
		    } else {
		        $tglbayar = '';
		        $nbayar = 0;
		        $jnsbayar='1';
		    }
		}
		
		 
		if ($kdharga !='KH01' ) {
		    if ($kdharga !='KH05' ) {
		        $tglbayar = date('Y-m-d H:m:s');
		        $nbayar = $netto;
		        if ($kdharga == 'KH01') {$jnsbayar='1';}
		        if ($kdharga == 'KH02') {$jnsbayar='3';}  
		        if ($kdharga == 'KH03') {$jnsbayar='4';}
		        if ($kdharga == 'KH04') {$jnsbayar='5';}    
		    }
		} 
		    
		
		
		
		$data = array(
			'total_penjualan' => $total_penjualan,
			'diskon' => $diskon,
			'total_penjualan_sdiskon' => $total_sdiskon,
			'ket_diskon' => $ket_diskon,
			'nbayar' => $nbayar,
			'tglbayar' => $tglbayar,
			'jnsbayar' => $jnsbayar,
			'netto' => $netto,
			'ndisc' => $dis,
			'nppn' => $nppn,
			
		);
		$this->db->where('no_faktur_penjualan', $noresi);
		$this->db->update('tabel_penjualan', $data);
		$uri = base_url('kasir/mesin-kasir-bayar/') . $noresi;
		header("Location: " . $uri, TRUE);
	}
	

	public function go_to_bayar1() {
		$noresi = $this->input->post('nofak_bayar');
		$layan = $this->input->post('layan');
		$kdharga = $this->input->post('kdharga');
		$total_penjualan = $this->input->post('total_belanja');
		$diskon = $this->input->post('diskon_belanja');
		$disc = $this->input->post('disc');
		$ndisc = $this->input->post('ndisc');
		$idpromo = $this->input->post('idpromo');
		$posting='1';
		$uri = base_url('kasir/mesin-kasir/') . $noresi;
		$this->db->query("UPDATE tabel_penjualan SET posting='1' WHERE  no_faktur_penjualan='$noresi';");
		$total_sdiskon = $total_penjualan - $diskon;
		if ($layan>1) {
		       if ($kdharga=='KH01') { 
			        $this->db->query("
				        INSERT IGNORE INTO tabel_rinci_penjualan(no_faktur_penjualan,kd_barang,nm_barang,jumlah,harga_modal,harga,kdpromo,sub_total_jual)
					        SELECT a.nobukti,a.kdbrg,c.nama_menu,SUM(a.qty),c.harga_modal,b.hargajual,'Takeaway',(sum(a.qty)*b.hargajual) FROM fakturpromo a
					        LEFT JOIN hargajual b ON b.kdbrg=a.kdbrg and b.kdharga='$kdharga' and b.kdcabang=mid('$noresi',1,5)
							LEFT JOIN tabel_menu c ON c.kode_menu=a.kdbrg
					        WHERE a.nobukti ='$noresi' 	
					        GROUP BY nobukti,kdbrg;");
				if ($layan=='3') {
				    $diskon=0;
				    $nilai=0;
				     $ongkir=$this->db->query("select a.nilai from ongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$noresi';");
				     $onk=$ongkir->row_array();    
				     
				     $dongkir=$this->db->query("select a.diskon from detailongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$noresi';"); 
				     $donk=$dongkir->row_array(); 
				     if(isset($donk)) {$diskon=$donk['diskon'];}
				     if(isset($onk)) {$nilai=$onk['nilai'];}
				     $netongkir=$nilai-$diskon;
				                             
				    $this->db->query("update tabel_penjualan set ongkir='$netongkir' where no_faktur_penjualan ='$noresi' ;");
				}	        
		       }
		       else {
		            $this->db->query("
				    INSERT IGNORE INTO tabel_rinci_penjualan(no_faktur_penjualan,kd_barang,nm_barang,jumlah,harga_modal,harga,kdpromo,sub_total_jual)
					        SELECT a.nobukti,a.kdbrg,b.nama_menu,SUM(a.qty),b.harga_modal,0,'Ojol',0 FROM fakturpromo a
					        LEFT JOIN tabel_menu b ON b.kode_menu=a.kdbrg
					        WHERE a.nobukti ='$noresi' 
					        GROUP BY nobukti,kdbrg;");
		       }
		}
		$dis=0;
		if ($idpromo != null) {
				$min=0;
				$max=0;
				$dd=0;
				
				$pr=$this->db->query("select minorder,maxdisc,disc1,ndisc1 from promoheader where idprogram='$idpromo';");
				$dprom=$pr->row_array();
				if(isset($dprom)) {
					$min=$dprom['minorder'];
					$max=$dprom['maxdisc'];
					$dd=$dprom['disc1'];
					$ndd=$dprom['ndisc1'];
					if ($total_sdiskon>=$min) {
						if ($dd>0){
							$dis=($total_sdiskon*($dd/100));
							if ($dis>$max) {$dis=$max;}	
							}
						if ($ndd>0) {$dis=$ndd;}	
					}
				}
		}	
		
		$this->db->query("UPDATE tabel_penjualan SET posting='1',netto=if(disc>0,(total_penjualan_sdiskon*(disc/100)),ndisc)+ongkir WHERE  no_faktur_penjualan='$noresi';");
		header("Location: " . $uri, TRUE);
	}

	public function mesin_kasir_bayar() {
		$noresi = $this->uri->segment(3);
		$username = $this->session->userdata('ses_username');
		$data_faktur = $this->kasir_model->getDataPenjualan($noresi, $username)->row();
		$list_barang = $this->kasir_model->getListPenjualan($noresi);
		if ($data_faktur) {
			$data['tgl'] = date('Y-m-d');
			$data['faktur'] = $data_faktur;
			$data['list'] = $list_barang;
			$data['tot_item'] = 0;
			$data['tot_ppn'] = 0;
			$data['tot_belanja'] = 0;
			$data['belanja'] = $this->kasir_model->getTotalBelanja($noresi)->row();
			$this->load->view('header', $data);
			$this->load->view('kasir/mesin_kasir_bayar');
		} else {
			$this->load->view('error404');
		}
	}
	
	public function dapur() {		
		$kdtoko = $this->session->userdata('kd_toko');
		$ntoko=$this->db->query("select * from tabel_toko where kd_toko='$kdtoko';");
		$tgl=date('Y-m-d');
		$ntoko1=$ntoko->row_array();
		$namatoko=$ntoko1['nm_toko'];
		$n=0;
		$n1=0;
		$n1a=0;
		$n1b=0;
		$n1c=0;
		$n1d=0;
		$n2=0;
		$n2a=0;
		$n2b=0;
		$n2c=0;
		$n2d=0;
		$n3=0;
		$n3a=0;
		$n3b=0;
		$n3c=0;
		$n3d=0;
		$n4=0;
		$n4a=0;
		$n4b=0;
		$n4c=0;
		$n4d=0;
		$n5=0;
		$n5a=0;
		$n5b=0;
		$n5c=0;
		$n5d=0;
		$n6=0;
		$n7=0;
		$n8=0;
		$n9=0;
		$n10=0;
		$n11=0;
		$n12=0;
		$n13=0;
		$n14=0;
		$n15=0;
		$jml=0;
		$antri=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'; ");
		$antri1=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0 order by nourut asc limit 0,1;");
		$antri2=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0  order by nourut asc limit 1,1;");
		$antri3=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0  order by nourut asc limit 2,1;");
		$antri4=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0  order by nourut asc limit 3,1;");
		$antri5=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0  order by nourut asc limit 4,1;");
		$antri6=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0  order by nourut asc limit 5,1;");
		$antri7=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0  order by nourut asc limit 6,1;");
		$antri8=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl' and jml>0  order by nourut asc limit 7,1;");
		$antri9=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'  and jml>0 order by nourut asc limit 8,1;");
		$antri10=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'  and jml>0 order by nourut asc limit 9,1;");
		$antri11=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'  and jml>0 order by nourut asc limit 10,1;");
		$antri12=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'  and jml>0 order by nourut asc limit 11,1;");
		$antri13=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'  and jml>0 order by nourut asc limit 12,1;");
		$antri14=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'  and jml>0 order by nourut asc limit 13,1;");
		$antri15=$this->db->query("select * from tabel_antri where kdcabang='$kdtoko' and stat='1' and tgl='$tgl'  and jml>0 order by nourut asc limit 14,1;");
		$a=$antri->row_array();
		$a1=$antri1->row_array();
		$a2=$antri2->row_array();
		$a3=$antri3->row_array();
		$a4=$antri4->row_array();
		$a5=$antri5->row_array();
		$a6=$antri6->row_array();
		$a7=$antri7->row_array();
		$a8=$antri8->row_array();
		$a9=$antri9->row_array();
		$a10=$antri10->row_array();
		$a11=$antri11->row_array();
		$a12=$antri12->row_array();
		$a13=$antri13->row_array();
		$a14=$antri14->row_array();
		$a15=$antri15->row_array();
	
		if(isset($a1)) {
			$fak1=$a1['nobukti'];
			$list1 = $this->kasir_model->getDatadapur1($fak1);				
			$list1a = $this->kasir_model->getDatadapur1a($fak1);				
			$list1b = $this->kasir_model->getDatadapur1b($fak1);				
			$list1c = $this->kasir_model->getDatadapur1c($fak1);				
			$list1d = $this->kasir_model->getDatadapur1d($fak1);				
			$data_faktur1 = $this->kasir_model->getDatadapurh1($fak1)->row();		
			if ($list1) { 
				$data['faktur1'] = $data_faktur1;
				$data['list1'] = $list1 ; 
				$n1=1;
				}			
			if ($list1a) {	
			    $data['list1a'] = $list1a ; 
				if($list1a->num_rows() > 0) { $n1a=2;}
			}
			if ($list1b) {	
			    $data['list1b'] = $list1b ; 
				if($list1b->num_rows() > 0) { $n1b=2;}
			    }
			if ($list1c) {	
			    $data['list1c'] = $list1c ; 
				if($list1c->num_rows() > 0) { $n1c=2;}
			    }    
			 if (isset($list1d)) {	
			    $data['list1d'] = $list1d ; 
				if($list1d->num_rows() > 0) { $n1d=2;}
			    }       
			
			}
		if(isset($a2)) {
			$fak2=$a2['nobukti'];
			$list2 = $this->kasir_model->getDatadapur2($fak2);	
			$list2a = $this->kasir_model->getDatadapur2a($fak2);	
			$list2b = $this->kasir_model->getDatadapur2b($fak2);	
			$list2c = $this->kasir_model->getDatadapur2c($fak2);	
			$list2d = $this->kasir_model->getDatadapur2d($fak2);	
			$data_faktur2 = $this->kasir_model->getDatadapurh2($fak2)->row();				
			if ($list2) { 
				$data['faktur2'] = $data_faktur2;
				$data['list2'] = $list2; 
				$n2=1;
				}
			if ($list2a) { 
				$data['list2a'] = $list2a; 
				if($list2a->num_rows() > 0) { $n2a=2;}
				}	
			if ($list2b) { 
				$data['list2b'] = $list2b; 
				if($list2b->num_rows() > 0) { $n2b=2;}
				}		
			if ($list2c) { 
				$data['list2c'] = $list2c; 
				if($list2c->num_rows() > 0) { $n2c=2;}
				}	
			if ($list2d) { 
				$data['list2d'] = $list2d; 
				if($list2d->num_rows() > 0) { $n2d=2;}
				}		
			}	
		if(isset($a3)) {
			$fak3=$a3['nobukti'];
			$list3 = $this->kasir_model->getDatadapur3($fak3);				
			$list3a = $this->kasir_model->getDatadapur3a($fak3);				
			$list3b = $this->kasir_model->getDatadapur3b($fak3);				
			$list3c = $this->kasir_model->getDatadapur3c($fak3);				
			$list3d = $this->kasir_model->getDatadapur3d($fak3);				
			$data_faktur3 = $this->kasir_model->getDatadapurh3($fak3)->row();				
			if ($data_faktur3) { 
				$data['faktur3'] = $data_faktur3;
				$data['list3'] = $list3; 
				$n3=1;
				}
			if ($list3a) { 
				$data['list3a'] = $list3a; 
				if($list3a->num_rows() > 0) { $n3a=2;}
				}		
			if ($list3b) { 
				$data['list3b'] = $list3b; 
				if($list3b->num_rows() > 0) { $n3b=2;}
				}			
			if ($list3c) { 
				$data['list3c'] = $list3c; 
				if($list3c->num_rows() > 0) { $n3c=2;}
				}			
			if ($list3d) { 
				$data['list3d'] = $list3d; 
				if($list3d->num_rows() > 0) { $n3d=2;}
				}				
			}	
		if(isset($a4)) {
			$fak4=$a4['nobukti'];
			$list4 = $this->kasir_model->getDatadapur4($fak4);				
			$list4a = $this->kasir_model->getDatadapur4a($fak4);				
			$list4b = $this->kasir_model->getDatadapur4b($fak4);				
			$list4c = $this->kasir_model->getDatadapur4c($fak4);				
			$list4d = $this->kasir_model->getDatadapur4d($fak4);				
			$data_faktur4 = $this->kasir_model->getDatadapurh4($fak4)->row();				
			if ($data_faktur4) { 
				$data['faktur4'] = $data_faktur4;
				$data['list4'] = $list4; 
				$n4=1;
				}	
			if ($list4a) { 
				$data['list4a'] = $list4a;
				if($list4a->num_rows() > 0) { $n4a=2;}
				}			
			if ($list4b) { 
				$data['list4b'] = $list4b; 
				if($list4c->num_rows() > 0) { $n4c=2;}
				}				
			if ($list4c) { 
				$data['list4c'] = $list4c; 
				if($list4c->num_rows() > 0) { $n4c=2;}
				}				
			if ($list4d) { 
				$data['list4d'] = $list4d; 
				if($list4d->num_rows() > 0) { $n4d=2;}
				
				}				
			}
		if(isset($a5)) {
			$fak5=$a5['nobukti'];
			$list5 = $this->kasir_model->getDatadapur5($fak5);				
			$list5a = $this->kasir_model->getDatadapur5a($fak5);				
			$list5b = $this->kasir_model->getDatadapur5b($fak5);				
			$list5c = $this->kasir_model->getDatadapur5c($fak5);				
			$list5d = $this->kasir_model->getDatadapur5d($fak5);				
			$data_faktur5 = $this->kasir_model->getDatadapurh5($fak5)->row();				
			if ($data_faktur5) { 
				$data['faktur5'] = $data_faktur5;
				$data['list5'] = $list5; 
				$n5=1;
				}
			if ($list5a) { 
				$data['list5a'] = $list5a; 
				if($list5a->num_rows() > 0) { $n5a=2;}
				}				
			if ($list5b) { 
				$data['list5b'] = $list5b; 
				if($list5b->num_rows() > 0) { $n5b=2;}
				}					
			if ($list5c) { 
				$data['list5c'] = $list5c; 
				if($list5c->num_rows() > 0) { $n5c=2;}
				}					
			if ($list5d) { 
				$data['list5d'] = $list5d; 
				if($list5d->num_rows() > 0) { $n5d=2;}
				}						
			}	
		if(isset($a6)) {
			$fak6=$a6['nobukti'];
			
			$list6 = $this->kasir_model->getDatadapur6($fak6);				
			$data_faktur6 = $this->kasir_model->getDatadapurh6($fak6)->row();				
			if ($data_faktur6) { 
				$data['faktur6'] = $data_faktur6;
				$data['list6'] = $list6; 
				$n6=1;
				}	
			}	
		if(isset($a7)) {
			$fak7=$a7['nobukti'];
			
			$list7 = $this->kasir_model->getDatadapur7($fak7);				
			$data_faktur7 = $this->kasir_model->getDatadapurh7($fak7)->row();				
			if ($data_faktur7) { 
				$data['faktur7'] = $data_faktur7;
				$data['list7'] = $list7; 
				$n7=1;
				}
			}	
		if(isset($a8)) {
			$fak8=$a8['nobukti'];
			
			$list8 = $this->kasir_model->getDatadapur8($fak8);				
			$data_faktur8 = $this->kasir_model->getDatadapurh8($fak8)->row();				
			if ($data_faktur8) { 
				$data['faktur8'] = $data_faktur8;
				$data['list8'] = $list8; 
				$n8=1;
				}	
			}	
		if(isset($a9)) {
			
			$fak9=$a9['nobukti'];
			$list9 = $this->kasir_model->getDatadapur9($fak9);
			$data_faktur9 = $this->kasir_model->getDatadapurh9($fak9)->row();				
			if ($data_faktur9) { 
				$data['faktur9'] = $data_faktur9;
				$data['list9'] = $list9; 
				$n9=1;
				}
			}	
		if(isset($a10)) {
			$fak10=$a10['nobukti'];
			
			$list10 = $this->kasir_model->getDatadapur10($fak10);
			$data_faktur10 = $this->kasir_model->getDatadapurh10($fak10)->row();				
			if ($data_faktur10) { 
				$data['faktur10'] = $data_faktur10;
				$data['list10'] = $list10; 
				$n10=1;
				}
			}	
		if(isset($a11)) {
			
			$fak11=$a11['nobukti'];
			$list11 = $this->kasir_model->getDatadapur11($fak11);
			$data_faktur11 = $this->kasir_model->getDatadapurh11($fak11)->row();				
			if ($data_faktur11) { 
				$data['faktur11'] = $data_faktur11;
				$data['list11'] = $list11; 
				$n11=1;
				}	
			}	
		if(isset($a12)) {
			
			$fak12=$a12['nobukti'];
			$list12 = $this->kasir_model->getDatadapur12($fak12);
			$data_faktur12 = $this->kasir_model->getDatadapurh12($fak12)->row();				
			if ($data_faktur12) { 
				$data['faktur12'] = $data_faktur12;
				$data['list12'] = $list12; 
				$n12=1;
				}	
			}	
		if(isset($a13)) {
			$fak13=$a13['nobukti'];
			
			$list13 = $this->kasir_model->getDatadapur13($fak13);
			$data_faktur13 = $this->kasir_model->getDatadapurh13($fak13)->row();				
			if ($data_faktur13) { 
				$data['faktur13'] = $data_faktur13;
				$data['list13'] = $list13; 
				$n13=1;
				}
			}	
		if(isset($a14)) {
			$fak14=$a14['nobukti'];
			
			$list14 = $this->kasir_model->getDatadapur14($fak14);
			$data_faktur14 = $this->kasir_model->getDatadapurh14($fak14)->row();				
			if ($data_faktur14) { 
				$data['faktur14'] = $data_faktur14;
				$data['list14'] = $list14; 
				$n14=1;
				}	
			}	
		if(isset($a15)) {
			
			$fak15=$a15['nobukti'];
			$list15 = $this->kasir_model->getDatadapur15($fak15);
			$data_faktur15 = $this->kasir_model->getDatadapurh15($fak15)->row();
			if ($data_faktur15) { 
				$data['faktur15'] = $data_faktur15;
				$data['list15'] = $list15; 
				$n15=1;
				}			
			}	
		if(isset($a)) {			
			$n=1;
			$listall = $this->kasir_model->getDatadapurall($kdtoko,$tgl);				
			$listalla = $this->kasir_model->getDatadapuralla($kdtoko,$tgl);				
			$listallb = $this->kasir_model->getDatadapurallb($kdtoko,$tgl);				
			$listallc = $this->kasir_model->getDatadapurallc($kdtoko,$tgl);				
			$listalld = $this->kasir_model->getDatadapuralld($kdtoko,$tgl);				
			$data['listall'] = $listall;	
			$data['listalla'] = $listalla;	
			$data['listallb'] = $listallb;	
			$data['listallc'] = $listallc;	
			$data['listalld'] = $listalld;	
		}
		$nt=$this->db->query("select * from tabel_toko where kd_toko='$kdtoko';");
		$nmt=$nt->row_array();
		$namatoko=$nmt['nm_toko'];
		$data['namatoko']=$namatoko;
		
			$data['tgl'] = date('Y-m-d');
			$data['tot_item'] = 0;
			$data['tot_item1'] = 0;
			$data['tot_item2'] = 0;
			$data['tot_item3'] = 0;
			$data['tot_item4'] = 0;
			$data['tot_item5'] = 0;
			$data['tot_item6'] = 0;
			$data['tot_item7'] = 0;
			$data['tot_item8'] = 0;
			$data['tot_item9'] = 0;
			$data['tot_item10'] = 0;
			$data['tot_item11'] = 0;
			$data['tot_item12'] = 0;
			$data['tot_item13'] = 0;
			$data['tot_item14'] = 0;
			$data['tot_item15'] = 0;
			$data['n'] = $n;
			$data['n1'] = $n1;
			$data['n1a'] = $n1a;
			$data['n1b'] = $n1b;
			$data['n1c'] = $n1c;
			$data['n1d'] = $n1d;
			$data['n2'] = $n2;
			$data['n2a'] = $n2a;
			$data['n2b'] = $n2b;
			$data['n2c'] = $n2c;
			$data['n2d'] = $n2d;
			$data['n3'] = $n3;
			$data['n3a'] = $n3a;
			$data['n3b'] = $n3b;
			$data['n3c'] = $n3c;
			$data['n3d'] = $n3d;
			$data['n4'] = $n4;
			$data['n4a'] = $n4a;
			$data['n4b'] = $n4b;
			$data['n4c'] = $n4c;
			$data['n4d'] = $n4d;
			$data['n5'] = $n5;
			$data['n5a'] = $n5a;
			$data['n5b'] = $n5b;
			$data['n5c'] = $n5c;
			$data['n5d'] = $n5d;
			$data['n6'] = $n6;
			$data['n7'] = $n7;
			$data['n8'] = $n8;
			$data['n9'] = $n9;
			$data['n10'] = $n10;
			$data['n11'] = $n11;
			$data['n12'] = $n12;
			$data['n13'] = $n13;
			$data['n14'] = $n14;
			$data['n15'] = $n15;
			
			$data['tot_ppn'] = 0;
			$data['tot_belanja'] = 0;
			$this->load->view('header', $data);
			$this->load->view('kasir/dapur_display');
		
	}
	public function masak() {
		$noresi = $this->input->post('nobuk');
		$jam=date('H:i:s');
		$this->db->query("update tabel_antri set stat='2',selesai='$jam' where nobukti='$noresi';");
		$uri = base_url('kasir/dapur/');
		header("Location: " . $uri, TRUE);
	}	
	
	public function transaksi_bayar() {
		$nofaktur = urldecode($this->uri->segment(3));
		$jnsbayar = urldecode($this->uri->segment(4));
		$cash = urldecode($this->uri->segment(5));
		$kembali = urldecode($this->uri->segment(6));
		$tglbayar = date('Y-m-d H:i:s');
		$uri = base_url('kasir/mesin_kasir_bayar/') . $nofaktur;
		$data = array(
				'jnsbayar' => $jnsbayar,
				'nbayar' => $cash,
				'nkembali' => $kembali,
				'tglbayar' => $tglbayar,
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $data);
			header("Location: " . $uri, TRUE);
		}	
		
		
		

	public function cekbarang() {
		$nofaktur = urldecode($this->uri->segment(3));
		$idbarang = urldecode($this->uri->segment(4));
		$produk = $this->kasir_model->getbarang($idbarang);
		$cek_sudah_ada = $this->kasir_model->cek_sudah_ada($idbarang, $nofaktur);
		$cek_stok = $this->kasir_model->cek_jumlah_stok($idbarang);
		$x = $produk->row_array();
		$harga_jual = $x['hargajual'];
		$ppn=0;
		$no=1;
		if($x['ppn']=='Y'){$ppn='10';}
			
		if ($x['jnspromo']==1) {$harga_jual = $x['hargajual'];}
		if ($x['jnspromo']==2) {
		    $harga_jual = $x['newharga'];
		    if ($harga_jual==null ) {$harga_jual = $x['hargajual'];}
		    }
		$jumlah = "1";
		$diskonrp = "0";
		$diskonpersen = "0";
		$nppn=0;
		$disrp="0";
		if($x['disc1']>0) {
			$diskonpersen=$x['disc1'];}
		if($x['disc1']==0) {
			if ($x['ndisc1']>0) {
			$disrp=$x['ndisc1'];}
		}
		
		$lay = $this->db->query("select layanan,posting,kdharga from tabel_penjualan where no_faktur_penjualan='$nofaktur';");
		$laya=$lay->row_array();
		$layanan=$laya['layanan'];
		$kdharga=$laya['kdharga'];
		
		$kb = $this->db->query("select a.kdbrgbonus,b.id,jnsbonus from tabel_menu a
								left join jenismenu b on a.jenisbrg=b.kdjenis
								where a.kode_menu='$idbarang';");
		$kbo=$kb->row_array();
		$kdbonus=$kbo['kdbrgbonus'];
		$idmenu=$kbo['id'];
		$jnsbonus=$kbo['jnsbonus'];
		
		
		
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;

		if ($produk->num_rows() > 0) {
			$i = $cek_stok->row_array();
			$stok_sekarang = $i['stok'];
			if ($cek_sudah_ada->num_rows() > 0) {
				$s = $cek_sudah_ada->row_array();
				$jum_beli = $s['jumlah'];
				$jum_beli_sekarang = $jumlah + $jum_beli;
				
				if ($diskonpersen>0) {
						$diskonrp=($harga_jual*$jum_beli_sekarang)*($diskonpersen/100);
					}
				if ($disrp>0) {
						$diskonrp=($disrp*$jum_beli_sekarang);
						}
					
				$subtot_sekarang = ($harga_jual * $jum_beli_sekarang) - $diskonrp;
				$nppn_sekarang=0;
				if ($ppn==10) {$nppn_sekarang=$subtot_sekarang*($ppn/100);}
				if ($jum_beli_sekarang > $stok_sekarang) {
			//		echo $this->session->set_flashdata('error', 'Periksa Transaksi Penerimaan Barang');
					$this->db->query("UPDATE tabel_rinci_penjualan SET ppn='$ppn',nppn='$nppn_sekarang',jumlah='$jum_beli_sekarang', sub_total_jual='$subtot_sekarang', diskonrp='$diskonrp', diskonpersen='$diskonpersen' WHERE kd_barang='$idbarang' AND no_faktur_penjualan='$nofaktur'");
					$this->db->query("UPDATE fakturpromo SET qty='$jum_beli_sekarang'  WHERE kdbrg1='$idbarang' AND nobukti='$nofaktur'");
					header("Location: " . $uri, TRUE);
				} else {
					$this->db->query("UPDATE tabel_rinci_penjualan SET ppn='$ppn',nppn='$nppn_sekarang',jumlah='$jum_beli_sekarang', sub_total_jual='$subtot_sekarang', diskonrp='$diskonrp', diskonpersen='$diskonpersen' WHERE kd_barang='$idbarang' AND no_faktur_penjualan='$nofaktur'");
					$this->db->query("UPDATE fakturpromo SET qty='$jum_beli_sekarang'  WHERE kdbrg1='$idbarang' AND nobukti='$nofaktur'");
					header("Location: " . $uri, TRUE);					
				}
			} else {
				$nourut=$no;
				$nou=$this->db->query("select max(nourut) as nourut from tabel_rinci_penjualan where no_faktur_penjualan='$nofaktur' and nourut<50;");
				if ($nou->num_rows() > 0) {
					$nour = $nou->row_array();
					$nourut = $nour['nourut']+1;
				}
				
				$nobonus=$nourut+50;
				
				if ($diskonpersen>0) {
						$diskonrp=($harga_jual*$jumlah)*($diskonpersen/100);
					}
				if ($disrp>0) {
						$diskonrp=($disrp*$jumlah);
						}
						
				$subtotal = ($harga_jual * $jumlah) - $diskonrp;	
				if ($ppn==10) {$nppn=$subtotal*($ppn/100);}
				if ($stok_sekarang < $jumlah) {
				//	echo $this->session->set_flashdata('error', 'Ada Transaksi Masuk Barang Belum Diproses');
				if ($jnsbonus == '1') {
					$kdbns = array(
							'nobukti' => $nofaktur,
							'kdbrg' => $kdbonus,
							'kdbrg1' => $x['kode_menu'],
							'qty' => $jumlah,
							'nourut' => $nobonus,
							'idmenu' => $idmenu,
							
						);
						$this->db->insert('fakturpromo', $kdbns);
				}
					if ($subtotal < 0) {
						echo $this->session->set_flashdata('error', 'Error');
						header("Location: " . $uri, TRUE);
					} else {
						$input = array(
							'no_faktur_penjualan' => $nofaktur,
							'kd_barang' => $x['kode_menu'],
							'nm_barang' => $x['nama_menu'],
							'jnsbarang' => $x['jenisbrg'],
							'jumlah' => $jumlah,
							'harga_modal' => $x['harga_modal'],
							'harga' => $harga_jual,
							'diskonrp' => $diskonrp,
							'ppn' => $ppn,
							'nppn' => $nppn,
							'diskonpersen' => $diskonpersen,
							'sub_total_jual' => $subtotal,
							'nourut' => $nourut,
							'idmenu' =>$idmenu,
							'takeaway'=>$layanan,
							
							
						);
						$this->db->insert('tabel_rinci_penjualan', $input);
					}
					header("Location: " . $uri, TRUE);
				} else {
					if ($diskonpersen>0) {
						$diskonrp=($harga_jual*$jumlah)*($diskonpersen/100);
					}
				if ($disrp>0) {
						$diskonrp=($disrp*$jumlah);
						}
						
				$subtotal = ($harga_jual * $jumlah) - $diskonrp;	
				if ($jnsbonus=='1') {
					$kdbns = array(
							'nobukti' => $nofaktur,
							'kdbrg' => $kdbonus,
							'kdbrg1' => $x['kode_menu'],
							'qty' => $jumlah,
							'nourut' => $nobonus,
							'idmenu' => $idmenu,
						);
						$this->db->insert('fakturpromo', $kdbns);
				}	
						
					if ($subtotal < 0) {
						echo $this->session->set_flashdata('error', 'Error');
						header("Location: " . $uri, TRUE);
						
					} else {
						$input = array(
							'no_faktur_penjualan' => $nofaktur,
							'kd_barang' => $x['kode_menu'],
							'nm_barang' => $x['nama_menu'],
							'jnsbarang' => $x['jenisbrg'],
							'jumlah' => $jumlah,
							'harga_modal' => $x['harga_modal'],
							'harga' => $harga_jual,
							'diskonrp' => $diskonrp,
							'ppn' => $ppn,
							'nppn' => $nppn,
							'diskonpersen' => $diskonpersen,
							'sub_total_jual' => $subtotal,
							'nourut' => $nourut,
							'idmenu' =>$idmenu,
							'takeaway'=>$layanan,
							
							
						);
						$this->db->insert('tabel_rinci_penjualan', $input);
						header("Location: " . $uri, TRUE);
					}
				}
			}
			if ($layanan>1) {
				$cek_sudah_ada1 = $this->kasir_model->cek_sudah_ada($kdbonus, $nofaktur);
					if ($cek_sudah_ada1->num_rows() > 0) {
						$this->db->query("UPDATE tabel_rinci_penjualan a SET a.jumlah=
							(select sum(qty) from fakturpromo WHERE kdbrg='$kdbonus' AND nobukti='$nofaktur')
							where no_faktur_penjualan='$nofaktur' and kd_barang='$kdbonus';");
						$this->db->query("UPDATE tabel_rinci_penjualan  SET sub_total_jual=jumlah*harga where no_faktur_penjualan='$nofaktur' and kd_barang='$kdbonus';");
					} else {
						 if ($kdharga=='KH01') { 
							$this->db->query("
									INSERT IGNORE INTO tabel_rinci_penjualan(no_faktur_penjualan,kd_barang,nm_barang,jumlah,harga_modal,harga,kdpromo,sub_total_jual,nourut,idmenu,takeaway)
									SELECT a.nobukti,a.kdbrg,c.nama_menu,SUM(a.qty),c.harga_modal,b.hargajual,'Takeaway',(sum(a.qty)*b.hargajual),nourut,idmenu,'$layanan' FROM fakturpromo a
									LEFT JOIN hargajual b ON b.kdbrg=a.kdbrg and b.kdharga='$kdharga' and b.kdcabang=mid('$nofaktur',1,5)
									LEFT JOIN tabel_menu c ON c.kode_menu=a.kdbrg
									WHERE a.nobukti ='$nofaktur' and a.kdbrg='$kdbonus'
									GROUP BY nobukti,kdbrg;");
						 } else  {
						
							$this->db->query("INSERT IGNORE INTO tabel_rinci_penjualan(no_faktur_penjualan,kd_barang,nm_barang,jumlah,harga_modal,harga,kdpromo,sub_total_jual,nourut,idmenu,takeaway)
									SELECT a.nobukti,a.kdbrg,b.nama_menu,SUM(a.qty),b.harga_modal,0,'Ojol',0,nourut,idmenu,'$layanan' FROM fakturpromo a
									LEFT JOIN tabel_menu b ON b.kode_menu=a.kdbrg
									WHERE a.nobukti ='$nofaktur' and a.kdbrg='$kdbonus'
									GROUP BY nobukti,kdbrg;");
						 }
					}	
			}
		} else {
			echo $this->session->set_flashdata('error', 'Kode ' . $idbarang . ' tidak tersedia :(');
			header("Location: " . $uri, TRUE);
		}
	}

	public function hapus_barang_beli() {
		$nofaktur = urldecode($this->uri->segment(3));
		$idbarang = urldecode($this->uri->segment(4));
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		$kb1 = $this->db->query("select kdbrgbonus from tabel_menu where kode_menu='$idbarang';");
		$kbo=$kb1->row_array();
		$kdbonus=$kbo['kdbrgbonus'];
		
		$kb = $this->db->query("select jumlah from tabel_rinci_penjualan WHERE no_faktur_penjualan='$nofaktur' AND kd_barang='$idbarang';");
		$kbo=$kb->row_array();
		$qtyhps=$kbo['jumlah'];
		
		$this->db->query("DELETE FROM tabel_rinci_penjualan WHERE no_faktur_penjualan='$nofaktur' AND kd_barang='$idbarang';");
		$this->db->query("update fakturpromo set qty=qty-'$qtyhps' WHERE nobukti='$nofaktur' AND kdbrg1='$idbarang';");
		$this->db->query("delete from  fakturpromo  WHERE nobukti='$nofaktur' AND kdbrg='$idbarang';");
		$this->db->query("delete from  fakturpromo  WHERE nobukti='$nofaktur' and qty=0;");
		$this->db->query("update tabel_rinci_penjualan set jumlah=jumlah-'$qtyhps' WHERE no_faktur_penjualan='$nofaktur' AND kd_barang='$kdbonus';");
		$this->db->query("delete from  tabel_rinci_penjualan  WHERE no_faktur_penjualan='$nofaktur' and jumlah=0;");
		$this->db->query("UPDATE tabel_rinci_penjualan  SET sub_total_jual=jumlah*harga where no_faktur_penjualan='$nofaktur' and kd_barang='$kdbonus';");
		header("Location: " . $uri, TRUE);
	}

	public function edit_jumlah_beli() {
		$idbarang = $this->input->post('kd_barang_e');
		$nofaktur = $this->input->post('nofak_e');
		$jumlah = $this->input->post('jml');
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		$cek_stok = $this->kasir_model->cek_jumlah_stok($idbarang);
		$rinci = $this->kasir_model->cek_sudah_ada($idbarang, $nofaktur);
		$i = $cek_stok->row_array();
		$x = $rinci->row_array();
		$stok_sekarang = $i['stok'];
		$diskonrp=$x['diskonrp'];
		$kb = $this->db->query("select kdbrgbonus from tabel_menu where kode_menu='$idbarang';");
		$kbo=$kb->row_array();
		$kdbonus=$kbo['kdbrgbonus'];
		$subtot_sekarang = ($x['harga']*$jumlah);
		$nppn=(($x['harga']*$jumlah)*($x['ppn']/100));
		if ($x['diskonpersen']>0) {
				$diskonrp = $jumlah * $x['harga'] * $x['diskonpersen'] / 100;
				$subtot_sekarang = ($x['harga'] * $jumlah) - $diskonrp;
				}
		if($x['diskonrp']>0) {		
			$subtot_sekarang = ($x['harga'] - $x['diskonrp'])*$jumlah;
			}
			//di sini
		
		if ($jumlah > $stok_sekarang) {
	//		echo $this->session->set_flashdata('error', 'Stok tidak cukup');
			$this->db->query("UPDATE tabel_rinci_penjualan SET jumlah='$jumlah', sub_total_jual='$subtot_sekarang', diskonrp='$diskonrp',nppn='$nppn' WHERE kd_barang='$idbarang' AND no_faktur_penjualan='$nofaktur'");
			$this->db->query("UPDATE fakturpromo SET qty='$jumlah'  WHERE kdbrg1='$idbarang' AND nobukti='$nofaktur'");
			$this->db->query("UPDATE tabel_rinci_penjualan a SET a.jumlah=
							(select sum(qty) from fakturpromo WHERE kdbrg='$kdbonus' AND nobukti='$nofaktur')
							where no_faktur_penjualan='$nofaktur' and kd_barang='$kdbonus';");
			$this->db->query("UPDATE tabel_rinci_penjualan  SET sub_total_jual=jumlah*harga where no_faktur_penjualan='$nofaktur' and kd_barang='$kdbonus';");
			header("Location: " . $uri, TRUE);
		} else {
			$this->db->query("UPDATE tabel_rinci_penjualan SET jumlah='$jumlah', sub_total_jual='$subtot_sekarang', diskonrp='$diskonrp',nppn='$nppn' WHERE kd_barang='$idbarang' AND no_faktur_penjualan='$nofaktur'");
			$this->db->query("UPDATE fakturpromo SET qty='$jumlah'  WHERE kdbrg1='$idbarang' AND nobukti='$nofaktur'");
			$this->db->query("UPDATE tabel_rinci_penjualan a SET a.jumlah=
							(select sum(qty) from fakturpromo WHERE kdbrg='$kdbonus' AND nobukti='$nofaktur')
							where no_faktur_penjualan='$nofaktur' and kd_barang='$kdbonus';");
			$this->db->query("UPDATE tabel_rinci_penjualan  SET sub_total_jual=jumlah*harga where no_faktur_penjualan='$nofaktur' and kd_barang='$kdbonus';");
			header("Location: " . $uri, TRUE);
		}
	}

	public function edit_diskon_beli() {
		$idbarang = $this->input->post('kd_barang_d');
		$nofaktur = $this->input->post('nofak_d');
		$diskonpersen = $this->input->post('dis_d');
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		$rinci = $this->kasir_model->cek_sudah_ada($idbarang, $nofaktur);
		$x = $rinci->row_array();
		$subtot_sekarang = ($x['harga'] * $x['jumlah']);
		
		if ($x['diskonpersen']>0) {
				$diskonrp = $x['jumlah'] * $x['harga'] * $x['diskonpersen'] / 100;
				$subtot_sekarang = ($x['harga'] * $x['jumlah']) - $diskonrp;
		}
		if($x['diskonrp']>0) {		
			$subtot_sekarang = ($x['harga'] - $x['diskonrp'])*$jumlah;
			}		
				
		if ($diskonpersen > 100) {
			echo $this->session->set_flashdata('error', 'Diskon tidak valid');
			header("Location: " . $uri, TRUE);
		} else {
			$this->db->query("UPDATE tabel_rinci_penjualan SET sub_total_jual='$subtot_sekarang', diskonrp='$diskonrp', diskonpersen='$diskonpersen' WHERE kd_barang='$idbarang' AND no_faktur_penjualan='$nofaktur'");
			header("Location: " . $uri, TRUE);
		}
	}

	public function hitung_diskon() {
		$nofaktur = $this->input->post('nofak_dis');
		$input_diskon = $this->input->post('diskon');
		$total_penjualan = $this->input->post('sum_belanja');
		$diskon = str_replace(".", "", $input_diskon);
		$ket_dis = $this->input->post('ket_dis');
		$penjualan_sdiskon = $total_penjualan - $diskon;
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		if ($penjualan_sdiskon < 0) {
			echo $this->session->set_flashdata('error', 'Diskon tidak valid');
			header("Location: " . $uri, TRUE);
		} else {
			$data = array(
				'total_penjualan' => $total_penjualan,
				'diskon' => $diskon,
				'total_penjualan_sdiskon' => $penjualan_sdiskon,
				'ket_diskon' => $ket_dis,
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $data);
			header("Location: " . $uri, TRUE);
		}
	}
	
	public function kode_harga() {
		$nofaktur = $this->input->post('nobuk');
		$kdharga = $this->input->post('kdharga');
		
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		if ($kdharga == 'KH01') {$keter='Reguler';}
		if ($kdharga == 'KH02') {$keter='Gofood';}
		if ($kdharga == 'KH03') {$keter='Grabfood';}
		if ($kdharga == 'KH04') {$keter='ShopeeFood';}
		if ($kdharga == 'KH05') {$keter='Reg Mandiri';}
		
		$data = array(				
				'kdharga' => $kdharga,
				'keter' => $keter,
										
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $data);
			header("Location: " . $uri, TRUE);
		
	}
	
	public function kode_harga_layan() {
		$nofaktur = $this->input->post('nobuk');
		$custno = $this->input->post('idpromo');
		$notelp = $this->input->post('notelp');
		$waiter1 = $this->input->post('waiter1');
		$waiter2 = $this->input->post('waiter2');
		$kurir = $this->input->post('kurir');
		$pinojol = $this->input->post('pinojol');
		$struk = $this->input->post('struk');
		$type = $this->input->post('type');
		$npelanggan = $this->input->post('npelanggan');
		$promo = $this->input->post('promo');
		$tamu = $this->input->post('tamu');
		$nomeja = $this->input->post('nomeja');
		$layan = $this->input->post('layan');
		$disc1=0;
		$diskon=0;
		$idprogram='';
		$noprogram='';
		$jnsdisc=0;
		$kod = $this->db->query("select a.kdcabang,a.kdharga,a.tgl_penjualan,a.waktu,b.jnsbayar,b.id,date_format(tgl_penjualan,'%w') as hari from tabel_penjualan a
								left join kodeharga b on a.kdharga=b.kdharga		
								where no_faktur_penjualan='$nofaktur';");
		if ($promo==2) {
					$kode=$kod->row_array();
					$kdharga=$kode['kdharga'];
					$kdcabang=$kode['kdcabang'];
					$tgl=$kode['tgl_penjualan'];
					$waktu=$kode['waktu'];
					$jnsbayar=$kode['jnsbayar'];
					$idbayar=$kode['id'];
					$hari=$kode['hari'];
					
					if (isset($custno)){
					$prom=$this->db->query("SELECT a.disc1,a.ndisc1,a.idprogram,a.nobukti,a.jnsdisc,a.jnspromo,a.jnsmenu FROM promoheader a
								WHERE a.idprogram='$custno';");
					}
					if(empty($custno)) {						
						$prom=$this->db->query("SELECT a.disc1,a.ndisc1,a.idprogram,a.nobukti,a.jnsdisc,a.jnspromo,a.jnsmenu FROM promoheader a
								LEFT JOIN promoarea b ON a.nobukti=b.nobukti
								WHERE a.stat='1' AND a.tglawal<='$tgl' AND a.tglakhir>='$tgl' AND a.jamawal<='$waktu' AND a.jamakhir>='$waktu'
								AND (a.jnslayanan='$layan' or a.jnslayanan1='$layan' or a.jnslayanan2='$layan' OR a.jnslayanan='0') AND b.kdwil='$kdcabang' and a.hari like '%$hari%'
								AND (a.custno='$idbayar' OR a.custno='$jnsbayar' OR a.custno='0');");
					}	
					$dprom=$prom->row_array();   
				
					if(isset($dprom)) {		
						$disc1=$dprom['disc1'];
						$diskon=$dprom['ndisc1'];
						$idprogram=$dprom['idprogram'];
						$noprogram=$dprom['nobukti'];
						$jnsdisc=$dprom['jnsdisc'];
						$jnspromo=$dprom['jnspromo'];
						$jnsmenu=$dprom['jnsmenu'];
					}
					
					
			}
		
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		$netongkir=0;
			if ($layan=='3') {
				    $diskon=0;
				    $nilai=0;
				     $ongkir=$this->db->query("select a.nilai from ongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$nofaktur';");
				     $onk=$ongkir->row_array();    
				     
				     $dongkir=$this->db->query("select a.diskon from detailongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$nofaktur';"); 
				     $donk=$dongkir->row_array(); 
				     if(isset($donk)) {$diskon=$donk['diskon'];}
				     if(isset($onk)) {$nilai=$onk['nilai'];}
				     $netongkir=$nilai-$diskon;
				}
		if ($layan !='1'){
			$kode=$kod->row_array();
			$kdharga=$kode['kdharga'];
			 if ($kdharga=='KH01') { 
							$this->db->query("
									INSERT IGNORE INTO tabel_rinci_penjualan(no_faktur_penjualan,kd_barang,nm_barang,jumlah,harga_modal,harga,kdpromo,sub_total_jual,nourut,idmenu,takeaway)
									SELECT a.nobukti,a.kdbrg,c.nama_menu,SUM(a.qty),c.harga_modal,b.hargajual,'Takeaway',(sum(a.qty)*b.hargajual),nourut,idmenu,'$layan' FROM fakturpromo a
									LEFT JOIN hargajual b ON b.kdbrg=a.kdbrg and b.kdharga='$kdharga' and b.kdcabang=mid('$nofaktur',1,5)
									LEFT JOIN tabel_menu c ON c.kode_menu=a.kdbrg
									WHERE a.nobukti ='$nofaktur' 
									GROUP BY nobukti,kdbrg;");
						 } else  {
						
							$this->db->query("INSERT IGNORE INTO tabel_rinci_penjualan(no_faktur_penjualan,kd_barang,nm_barang,jumlah,harga_modal,harga,kdpromo,sub_total_jual,nourut,idmenu,takeaway)
									SELECT a.nobukti,a.kdbrg,b.nama_menu,SUM(a.qty),b.harga_modal,0,'Ojol',0,nourut,idmenu,'$layan' FROM fakturpromo a
									LEFT JOIN tabel_menu b ON b.kode_menu=a.kdbrg
									WHERE a.nobukti ='$nofaktur' 
									GROUP BY nobukti,kdbrg;");
						 }
		}			
		if ($layan=='1') {
		        $this->db->query("delete from tabel_rinci_penjualan where no_faktur_penjualan='$nofaktur' and (kdpromo like '%Takeaway%' or kdpromo like '%Ojol%');");        
		        }
		if ($idprogram=='')	{
			$this->db->query("update tabel_rinci_penjualan a, hargajual b,tabel_penjualan c set a.disc2=0,a.ndisc2=0,a.diskonpersen=0,a.diskonrp=0,a.harga=b.hargajual,takeaway='$layan',
			a.sub_total_jual=jumlah*b.hargajual,a.nppn=((jumlah*b.hargajual)*(a.ppn/100)) where a.no_faktur_penjualan=c.no_faktur_penjualan and a.no_faktur_penjualan='$nofaktur' and c.kdharga=b.kdharga and c.kdcabang=b.kdcabang and a.kd_barang=b.kdbrg;");
			//$this->db->query("update tabel_penjualan set disc=0,ndisc=0,netto=total_penjualan where no_faktur_penjualan='$nofaktur';");
			}	
		if ($idprogram !='') {
		        if ($jnsdisc=='1') {
			            $this->db->query("update tabel_rinci_penjualan a,promodetail b set a.diskonpersen=if(b.disc1>0,b.disc1,0),takeaway='$layan',
			            a.diskonrp=if(b.disc1>0,(a.jumlah*a.harga*(b.disc1/100)),b.ndisc1*a.jumlah),a.sub_total_jual=(a.jumlah*a.harga)-(if(b.disc1>0,(a.jumlah*a.harga*(b.disc1/100)),b.ndisc1*a.jumlah)),
						a.nppn=((a.jumlah*a.harga)-(if(b.disc1>0,(a.jumlah*a.harga*(b.disc1/100)),b.ndisc1*a.jumlah))*(a.ppn/100))
				        where no_faktur_penjualan='$nofaktur' and a.kd_barang=b.kdbrg and b.idpromo='$idprogram' and b.kdcabang='$kdcabang' ;");
		        }
		        if ($jnsdisc=='2') {
			            $this->db->query("update tabel_rinci_penjualan a,promodetail b set 
			            a.harga=b.newharga,
			            a.sub_total_jual=(a.jumlah*b.newharga),
						a.nppn=((a.jumlah*b.newharga)*(a.ppn/100))
				        where no_faktur_penjualan='$nofaktur' and a.kd_barang=b.kdbrg and b.idpromo='$idprogram' and b.kdcabang='$kdcabang' ;");
		        }
			}			
		$data = array(				
				'layanan' => $layan,
				'custno' =>$custno,
				'notelp' =>$notelp,
				'waiter1' =>$waiter1,
				'waiter2' =>$waiter2,
				'kurir' =>$kurir,
				'pinojol' =>$pinojol,
				'struk' =>$struk,
				'typecust' =>$type,
				'npelanggan' =>$npelanggan,
				'promo' =>$promo,
				'tamu' =>$tamu,
				'nomeja' =>$nomeja,
				'ongkir' =>$netongkir,
				'disc'=>$disc1,
				'diskon'=>$diskon,
				'idpromo'=>$idprogram,
				'jnspromo'=>$jnsdisc,
				'posting'=>'2',
				
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $data);
			
			header("Location: " . $uri, TRUE);
	}
	
	public function kode_harga_layan1() {
		$nofaktur = $this->input->post('nobuk');
		$tglfaktur = $this->input->post('tgl');
		$noorder = $this->input->post('noorder');
		$kd_toko = $this->session->userdata('kd_toko');
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		$custno='';
		$npelanggan='';
		$promo='';
		$kdcabang='';
		$notelp='';
		$kdharga='';
		$an=NULL;
		$cek_an = $this->kasir_model->cek_sudah_ada_order($noorder); //disini
		$ia = $cek_an->row_array();
		if(isset($ia)) {
		    $an = $ia['no_faktur_penjualan'];
		    $ntgl = $ia['tgl_penjualan'];
		    $ns = $ia['selesai'];
		    $nc = $ia['kdcabang'];
	        if ($an != null) {
				echo $this->session->set_flashdata('error', 'No Order Ini sudah diProses Dengan No:  '.$an);
				header("Location: " . $uri, TRUE);
	        }
		}
		$inv = $this->db->query("select * from tbl_invoice a
		                        left join tbl_pelanggan b on a.inv_plg_id=b.plg_id
		                        where a.inv_no='$noorder' and a.kdcabang='$kd_toko';");
		$inva=$inv->row_array();
		if (isset($inva)) {
		    $custno=$inva['inv_plg_id'];
		    $npelanggan=$inva['inv_plg_nama'];
		    $kdharga=$inva['layanan'];
		    $promo=$inva['promo'];
		    $kdcabang=$inva['kdcabang'];
		    $notelp=$inva['plg_notelp'];
		    $jnsbayar=$inva['jnsbayar'];
		    }
		$type='2';
		$waiter1 = $this->input->post('waiter1');
		$waiter2 = $this->input->post('waiter2');
		$kurir = $this->input->post('kurir');
		$struk = $this->input->post('struk');
		$nomeja = $this->input->post('nomeja');
		
		
		$netongkir=0;
			if ($kdharga=='3') {
				    $diskon=0;
				    $nilai=0;
				     $ongkir=$this->db->query("select a.nilai from ongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$nofaktur';");
				     $onk=$ongkir->row_array();    
				     
				     $dongkir=$this->db->query("select a.diskon from detailongkir a
				                             left join tabel_penjualan b on a.kode=b.kdcabang
				                             where a.st='1' and a.drtgl<=b.tgl_penjualan and a.smptgl>=b.tgl_penjualan
				                             and b.no_faktur_penjualan='$nofaktur';"); 
				     $donk=$dongkir->row_array(); 
				     if(isset($donk)) {$diskon=$donk['diskon'];}
				     if(isset($onk)) {$nilai=$onk['nilai'];}
				     $netongkir=$nilai-$diskon;
				}	        
		
		
		$data = array(				
				'layanan' => $kdharga,
				'custno' =>$custno,
				'notelp' =>$notelp,
				'waiter1' =>$waiter1,
				'waiter2' =>$waiter2,
				'kurir' =>$kurir,
				'struk' =>$struk,
				'typecust' =>$type,
				'npelanggan' =>$npelanggan,
				'promo' =>$promo,
				'nomeja' =>$nomeja,
				'ongkir' =>$netongkir,
				'noorder' =>$noorder,
				'posting' =>'2',
				'jnsbayar' =>$jnsbayar,
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $data);
			
		if ($an == null) {	
	//	$invd=$this->db->query("
//		        select a.detail_menu_id,a.detail_menu_nama,a.detail_porsi,b.hargajual,if(b.ppn='Y',10,0) as ppn,(a.detail_porsi*b.hargajual) as sub_total_jual,((a.detail_porsi*b.hargajual)*(10/100)) as nppn,d.id as idmenu,c.harga_modal
//		        from tbl_detail a
//		        left join hargajual b on a.detail_menu_id=b.kdbrg 
//		        left join tabel_menu c on c.kode_menu=a.detail_menu_id
//		        left join jenismenu d on c.jenisbrg=d.kdjenis
//		        where a.detail_inv_no='$noorder' and b.kdharga='KH01' and kdcabang='$kd_toko' and b.tglawal<='$tglfaktur' and tglakhir>='$tglfaktur' ");
//		$invad=$invd->row_array();
//		if (isset($invad)) {
//		    $kd_barang=$invad['detail_menu_id'];
//		    $nm_barang=$invad['detail_menu_nama'];
//		    $jumlah=$invad['detail_porsi'];
//		    $harga=$invad['hargajual'];
//		    $harga_modal=$invad['harga_modal'];
//		    $ppn=$invad['ppn'];
//		    $nppn=$invad['nppn'];
//		    $idmenu=$invad['idmenu'];
//		    $sub_total_jual=$invad['sub_total_jual'];
		
			
//			$data1 = array(				
//				'no_faktur_penjualan' => $nofaktur,
//				'kd_barang' =>$kd_barang,
//				'nm_barang' =>$nm_barang,
//				'jumlah' =>$jumlah,
//				'harga_modal' =>$harga_modal,
//				'harga' =>$harga,
//				'sub_total_jual' =>$sub_total_jual,
//				'ppn' =>$ppn,
//				'nppn' =>$nppn,
//				'idmenu' =>$idmenu,
//				
//			);
//			$this->db->insert('tabel_rinci_penjualan', $data1);
//		}	
			
			$upd=$this->db->query("update tbl_invoice set nobukti='$nofaktur',inv_status='Menunggu Pembayaran',stat='2' where inv_no='$noorder' ");
		}
			header("Location: " . $uri, TRUE);
	}
	
	
	public function kode_harga_token() {
		$nofaktur = $this->input->post('nobuk');
		$token = $this->input->post('token');
		$idtoken = $this->input->post('idtoken');
		$note = $this->input->post('note');
		$password=(($token/1305));
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		
		if ($password != $idtoken) {
			echo $this->session->set_flashdata('error', 'Password Salah');
			$uri = base_url('kasir/mesin-kasir-bayar/') . $nofaktur;
			header("Location: " . $uri, TRUE);
		} else {
			$data = array(
				'token' => $token,
				'idtoken' => $idtoken,
				'note' => $note,
				'posting' =>'5',
				'nbayar' =>'0',
				'nkembali' =>'0',
				
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $data);
			$this->db->query("delete from tabel_rinci_penjualan where no_faktur_penjualan='$nofaktur' and (kdpromo like '%Takeaway%' or kdpromo like '%Ojol%');");        
			header("Location: " . $uri, TRUE);
		}
		
	}
	
	public function kode_harga1() {
		$nofaktur = $this->input->post('nobuk');
		$kdharga = $this->input->post('kdharga');
		$tgl = $this->input->post('tgl');
		$posting = $this->input->post('posting');
		$kdcabang = $this->input->post('kdcabang');
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		if ($kdharga == 'KH01') {
			$keter='Reguler';
			$layanan='1';
			$jnsbayar='1';
		}
		if ($kdharga == 'KH05') {
			$keter='Reg Mandiri';
			$layanan='1';
			$jnsbayar='1';
		}
		if ($kdharga == 'KH02') {
			$keter='Gofood';
			$layanan='2';
			$jnsbayar='3';
			}
		if ($kdharga == 'KH03') {
			$keter='Grabfood';
			$layanan='2';
			$jnsbayar='4';
			}
		if ($kdharga == 'KH04') {
			$keter='ShopeeFood';
			$layanan='2';
			$jnsbayar='5';
			}
		if ($posting=='0' or $posting=='5') {	
	    $this->db->query("UPDATE tabel_penjualan SET kdharga='$kdharga',keter='$keter',layanan='$layanan',jnsbayar='$jnsbayar'  WHERE  no_faktur_penjualan='$nofaktur';");
	    $this->db->query("UPDATE tabel_rinci_penjualan a,hargajual b SET a.harga=b.hargajual ,a.sub_total_jual=(a.jumlah*b.hargajual),a.ppn=IF(b.ppn='Y',10,0),a.nppn=((a.jumlah*b.hargajual)*(a.ppn/100))
		                    WHERE a.no_faktur_penjualan='$nofaktur'
		                    AND b.kdharga='$kdharga' 
		                    AND a.kd_barang=b.kdbrg
		                    AND b.tglawal<='$tgl'
		                    AND b.tglakhir>='$tgl'
		                    AND b.kdcabang='$kdcabang';");
		    if ($kdharga =='KH01') {
		    if ($layanan=='1') {
		        $this->db->query("delete from tabel_rinci_penjualan where no_faktur_penjualan='$nofaktur' and (kdpromo like '%Takeaway%' or kdpromo like '%Ojol%');");  
		        }
		    }
		}
		header("Location: " . $uri, TRUE);
	}

	public function kode_harga2() {
		$nofaktur = $this->input->post('nobuk');
		$jenisbrg = $this->input->post('jenis');
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		
		$data = array(				
				'jnsmenu' => $jenisbrg,
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $data);
			header("Location: " . $uri, TRUE);
		
	}


	public function simpan_edit() {
		$nofaktur = $this->input->post('nobuk');
		$kdbrg = $this->input->post('kdbrg');
		$jenis = $this->input->post('jenis');
		$takeaway = $this->input->post('takeaway');
		$note = $this->input->post('note');
		
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		
		$data = array(				
				'jenis' => $jenis,
				'takeaway' => $takeaway,
				'note' => $note,
				
			);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->where('kd_barang', $kdbrg);
			$this->db->update('tabel_rinci_penjualan', $data);
			header("Location: " . $uri, TRUE);
		
	}

	function get_autocomplete() {
		if (isset($_GET['term'])) {
			$result = $this->kasir_model->cari_nama($_GET['term']);
			if (count($result) > 0) {
				foreach ($result as $row) {
					$arr_result[] = array(
						'label' => $row->nama_menu,
						'kode' => $row->kode_menu,
					);
				}
				echo json_encode($arr_result);
			}
		}
	}

	public function cetak_struk() {
		$tgl = date('Y-m-d');
		$waktu = date('H:i:s');
		$kdtoko = $this->session->userdata('kd_toko');
		$sekarang=  date('d-m-Y H:i:s');
		$debet = 0;
		$bayar = 0;
		$id_user = $this->session->userdata('ses_username');
		$nofaktur = $this->input->post('nofak_print');
		$diskon = $this->input->post('diskon_print');
		$total_penjualan = $this->input->post('sum_print');
		$bayar = $this->input->post('display');
		$debet = $this->input->post('debet_print');
		$bank = $this->input->post('bank_print');
		$kdharga = $this->input->post('kdharga');
		$noorder = $this->input->post('noorder');
		$stok_bahan=0;
		$stok_potong=0;
		$cash = $total_penjualan - $debet;
		$kembali = ($bayar + $debet) - $total_penjualan;
		$selesai = 1;
		$ket_ks = "Penjualan " . $nofaktur;
		$uri = base_url('kasir/mesin-kasir/') . $nofaktur;
		$this->db->trans_start();
		$data_faktur = $this->kasir_model->getPenjualanSelesai($nofaktur)->row();
		$datastruk = $this->kasir_model->getPenjualanstruk($nofaktur);
		$sd = $datastruk->row_array();
		$struk=$sd['struk'];
		$notelp=$sd['notelp'];
		
		$list_produk = $this->kasir_model->getProdukDijual($nofaktur)->result();
		$stat=$data_faktur->selesai;
		if ($data_faktur && $list_produk) {
			foreach ($list_produk as $key) {
				$kd_barang_item = $key->kd_barang;
				$jumlah_item = $key->jumlah;
				$validasi_stok = $this->kasir_model->getStok($kd_barang_item);
				$i = $validasi_stok->row_array();
				$stok_sekarang = $i['stok'];
			//	if ($stok_sekarang < $jumlah_item) {
			//		echo $this->session->set_flashdata('error', 'Stok ada yang kurang');
			//		header("Location: " . $uri, TRUE);
			//		return false;
			//	} else {
			
					$stok_porsi = $this->kasir_model->getStokPorsi($kd_barang_item)->result();
					foreach ($stok_porsi as $key) {
						$kd_bahan = $key->kode_bahan;
						$cek_sudah_ada = $this->kasir_model->cek_ada($kd_bahan, $kdtoko);
						$ctok = $this->kasir_model->cek_stok($kd_bahan, $kdtoko);
						$cekst = $ctok->row_array();
						if(isset($cekst)) {
				            $stok_bahan = $cekst['stok'];
						}
						
						$rinci_bahan = $key->qty;
						$stok_baru = $stok_bahan - ($jumlah_item*$rinci_bahan);
						$stok_potong=$jumlah_item*$rinci_bahan;
					if ($stat=='0') {
							if ($cek_sudah_ada->num_rows() > 0) {
						        $this->db->query("UPDATE tabel_stok_toko SET stok='$stok_baru',tgl_perubahan='$sekarang'  WHERE kd_barang='$kd_bahan' and kd_toko='$kdtoko'");
							} else {
							    $this->db->query("insert ignore into tabel_stok_toko (kd_toko,kd_barang,stok,stok_min,tgl_perubahan,ket) value ('$kdtoko','$kd_bahan','$stok_baru','5', '$sekarang','')");
							}
					
						$this->db->query("INSERT INTO tabel_kartu_stok (kode_toko,kode_barang,waktu,jam,sebelumnya,keluar,masuk,saldo,keterangan,user,publish,nobukti,kdbrg) VALUES ('$kdtoko','$kd_bahan','$tgl','$waktu','$stok_bahan','$stok_potong','0','$stok_baru','$ket_ks','$id_user','0','$nofaktur','$kd_barang_item')");
					}
			//		}
				}
			};
			if($kdharga=='KH05'){
			    $this->db->query("update tbl_invoice set stat='3',inv_status='Pembayaran Selesai' where inv_no='$noorder'");
			    }
			$update = array(
				'waktu' => $waktu,
				'cash' => $cash,
				'debet' => $debet,
				'ket' => $bank,
				'selesai' => $selesai,
			);
			$this->db->where('id_user', $id_user);
			$this->db->where('no_faktur_penjualan', $nofaktur);
			$this->db->update('tabel_penjualan', $update);
			$this->db->trans_complete();
			$data_cetak['toko'] = $this->kasir_model->get_toko();
			$data_cetak['faktur'] = $data_faktur;
			$data_cetak['tgl'] = $tgl;
			$data_cetak['waktu'] = $waktu;
			$data_cetak['bayar'] = $bayar;
			$data_cetak['notelp'] = $notelp;
			$data_cetak['kembali'] = $kembali;
			$data_cetak['debet'] = $debet;
			$data_cetak['produk'] = $list_produk;
			$data_cetak['produk'] = $list_produk;
			$data_cetak['total_item'] = 0;
			$data_cetak['subtotal'] = 0;
			if ($struk==1) {
			    $this->load->view('kasir/struk_transaksi_baru', $data_cetak);
			} else {
			    $this->load->view('kasir/struk_transaksi', $data_cetak);
			}
			
		} else {
			echo "Error retrieving information from server. <br><br>Halaman ini tidak bisa dimuat ulang, silahkan tutup halaman ini.";
		}
	}

	public function transaksi_selesai() {
		$this->load->view('header');
		$this->load->view('kasir/transaksi_selesai');
	}

	public function hapus_faktur() {
		$nofaktur = urldecode($this->uri->segment(3));
		$this->db->query("DELETE FROM tabel_penjualan WHERE no_faktur_penjualan='$nofaktur'");
		$this->db->query("DELETE FROM tabel_rinci_penjualan WHERE no_faktur_penjualan='$nofaktur'");
		$this->db->query("DELETE FROM fakturpromo WHERE nobukti='$nofaktur'");
		echo $this->session->set_flashdata('msg', 'Faktur berhasil ' . $nofaktur . ' dihapus');
		redirect('kasir/penjualan-pending/', 'refresh');
	}

}

/* End of file Kasir.php */
/* Location: ./application/controllers/Kasir.php */